/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import io.krakens.grok.api.Grok;
import io.krakens.grok.api.Match;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.strings.GrokMatch;
import org.graylog2.grok.GrokPatternRegistry;

public class MultiGrokMatch
extends AbstractFunction<GrokMatch.GrokResult> {
    public static final String NAME = "multi_grok";
    private static final Class<List<String>> LIST_RETURN_TYPE = new TypeToken<List<String>>(){}.getRawType();
    private final ParameterDescriptor<String, String> valueParam;
    private final ParameterDescriptor<Object, List<String>> patternsParam;
    private final ParameterDescriptor<Boolean, Boolean> namedOnly;
    private final GrokPatternRegistry grokPatternRegistry;

    @Inject
    public MultiGrokMatch(GrokPatternRegistry grokPatternRegistry) {
        this.grokPatternRegistry = grokPatternRegistry;
        this.valueParam = ParameterDescriptor.string("value").description("The string to apply each Grok pattern against").build();
        this.patternsParam = ParameterDescriptor.object("patterns", LIST_RETURN_TYPE).description("The Grok patterns to match in order").transform(this::transformToList).build();
        this.namedOnly = ParameterDescriptor.bool("only_named_captures").optional().description("Whether to only use explicitly named groups in the patterns").build();
    }

    @Override
    public GrokMatch.GrokResult evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        List<String> patterns = this.patternsParam.required(args, context);
        boolean onlyNamedCaptures = this.namedOnly.optional(args, context).orElse(false);
        if (value == null || patterns == null || patterns.isEmpty()) {
            return null;
        }
        for (String pattern : patterns) {
            Grok grok = this.grokPatternRegistry.cachedGrokForPattern(pattern, onlyNamedCaptures);
            Match match = grok.match((CharSequence)value);
            if (match.isNull().booleanValue()) continue;
            return new GrokMatch.GrokResult(match.captureFlattened());
        }
        return new GrokMatch.GrokResult(Map.of());
    }

    private List<String> transformToList(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(Object::toString).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public FunctionDescriptor<GrokMatch.GrokResult> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(GrokMatch.GrokResult.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.patternsParam, this.valueParam, this.namedOnly)).description("Applies a list of Grok patterns to a string and returns the first match").build();
    }
}

