/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class RegexReplace
extends AbstractFunction<String> {
    public static final String NAME = "regex_replace";
    private final ParameterDescriptor<String, Pattern> patternParam = ParameterDescriptor.string("pattern", Pattern.class).transform(Pattern::compile).description("The regular expression to which the \"value\" string is to be matched; uses Java regex syntax").build();
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").ruleBuilderVariable().description("The string to match the pattern against").build();
    private final ParameterDescriptor<String, String> replacementParam = ParameterDescriptor.string("replacement").description("The string to be substituted for the first or all matches").build();
    private final ParameterDescriptor<Boolean, Boolean> replaceAllParam = ParameterDescriptor.bool("replace_all").optional().description("Replace all matches if \"true\", otherwise only replace the first match. Default: true").build();

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        Pattern pattern = this.patternParam.required(args, context);
        String value = this.valueParam.required(args, context);
        String replacement = this.replacementParam.required(args, context);
        boolean replaceAll = this.replaceAllParam.optional(args, context).orElse(true);
        Preconditions.checkArgument((pattern != null ? 1 : 0) != 0, (Object)"Argument 'pattern' cannot be 'null'");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Argument 'value' cannot be 'null'");
        Preconditions.checkArgument((replacement != null ? 1 : 0) != 0, (Object)"Argument 'replacement' cannot be 'null'");
        if (replaceAll) {
            return pattern.matcher(value).replaceAll(replacement);
        }
        return pattern.matcher(value).replaceFirst(replacement);
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(NAME).pure(true).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.patternParam, this.valueParam, this.replacementParam, this.replaceAllParam)).description("Match a string with a regular expression (Java syntax) and replace all matches with string").ruleBuilderEnabled().ruleBuilderName("Regex replace").ruleBuilderTitle("Match the regular expression '${pattern}' against '${value}' and replace it with '${replacement}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.STRING).build();
    }
}

