/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.db.migrations;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragmentService;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20220522125200_AddSetGrokToFieldsExtractorFragments
extends Migration {
    private static final Logger log = LoggerFactory.getLogger(V20220522125200_AddSetGrokToFieldsExtractorFragments.class);
    private final RuleFragmentService ruleFragmentService;

    @Inject
    public V20220522125200_AddSetGrokToFieldsExtractorFragments(RuleFragmentService ruleFragmentService) {
        this.ruleFragmentService = ruleFragmentService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-05-22T12:52:00Z");
    }

    @Override
    public void upgrade() {
        log.debug("Adding set_grok_to_fields extractor fragments via migration");
        this.ruleFragmentService.upsert(V20220522125200_AddSetGrokToFieldsExtractorFragments.createSetGrokToFieldsFragment());
        log.debug("set_grok_to_fields fragment was successfully added");
    }

    static RuleFragment createSetGrokToFieldsFragment() {
        return RuleFragment.builder().fragment("let gl2_fragment_grok_results = grok(\n  pattern: ${grokPattern},\n  value: to_string($message.${field})<#if grokNamedOnly??>,\n  only_named_captures: ${grokNamedOnly?c}</#if>\n);\nset_fields(\n  fields: gl2_fragment_grok_results<#if prefix??>,\n  prefix: ${prefix!\"\"}</#if><#if suffix??>,\n  suffix: ${suffix!\"\"}</#if>\n);").descriptor(FunctionDescriptor.builder().name("set_grok_to_fields").params((ImmutableList<ParameterDescriptor>)ImmutableList.of(ParameterDescriptor.string("field").description("Field to extract and apply grok pattern to").build(), ParameterDescriptor.string("grokPattern").description("Grok pattern to apply").build(), ParameterDescriptor.bool("grokNamedOnly").optional().description("Set to true to only set fields for named captures").build(), ParameterDescriptor.string("prefix").optional().description("Prefix for created fields").build(), ParameterDescriptor.string("suffix").optional().description("Suffix for created fields").build())).returnType(Void.class).description("Match grok pattern and set fields").ruleBuilderEnabled().ruleBuilderName("Extract grok to fields").ruleBuilderTitle("Match grok pattern '${grokPattern}' on field '${field}' and set fields for matches").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.EXTRACTORS).build()).build();
    }
}

