/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.querystrings;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.PushOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import jakarta.inject.Inject;
import java.time.Clock;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.bson.conversions.Bson;
import org.graylog.plugins.views.search.querystrings.LastUsedQueryStringsService;
import org.graylog.plugins.views.search.querystrings.QueryString;
import org.graylog.plugins.views.search.querystrings.QueryStringForUser;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.database.users.User;
import org.graylog2.users.events.UserDeletedEvent;

public class MongoLastUsedQueryStringsService
implements LastUsedQueryStringsService {
    public static final String COLLECTION_NAME = "query_strings";
    private static final Integer MAX_LENGTH = 100;
    private final Integer maxLength;
    private final MongoCollection<QueryStringForUser> collection;
    private final Clock clock;

    public MongoLastUsedQueryStringsService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, EventBus eventBus, Integer maxLength) {
        this.collection = mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME, QueryStringForUser.class);
        this.clock = Clock.systemDefaultZone();
        this.maxLength = maxLength;
        eventBus.register((Object)this);
        this.collection.createIndex((Bson)new BasicDBObject("user_id", (Object)1));
        this.collection.createIndex((Bson)new BasicDBObject("items.grn", (Object)1));
    }

    @Inject
    public MongoLastUsedQueryStringsService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, EventBus eventBus) {
        this(mongoConnection, mapper, eventBus, MAX_LENGTH);
    }

    @Override
    public List<QueryString> get(User user, int limit) {
        return this.findForUser(user.getId()).map(QueryStringForUser::items).map(items -> items.stream().limit(limit).toList()).orElse(List.of());
    }

    private Optional<QueryStringForUser> findForUser(String userId) {
        return Optional.ofNullable((QueryStringForUser)this.collection.find(Filters.eq((String)"user_id", (Object)userId), QueryStringForUser.class).first());
    }

    @Override
    public void save(User user, String queryString) {
        QueryString newItem = new QueryString(queryString, Date.from(this.clock.instant()));
        this.collection.updateOne(Filters.eq((String)"user_id", (Object)user.getId()), Updates.pull((String)"items", (Object)Filters.eq((String)"query", (Object)queryString)));
        this.collection.updateOne(Filters.eq((String)"user_id", (Object)user.getId()), Updates.pushEach((String)"items", List.of(newItem), (PushOptions)new PushOptions().position(Integer.valueOf(0)).slice(this.maxLength)), new UpdateOptions().upsert(true));
    }

    @Subscribe
    public void removeQueryStringsUponUserDeletion(UserDeletedEvent userDeletedEvent) {
        this.collection.deleteOne(Filters.eq((String)"user_id", (Object)userDeletedEvent.userId()));
    }
}

