/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.backend;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import jakarta.inject.Inject;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.AuthServiceCredentials;
import org.graylog.security.authservice.AuthenticationDetails;
import org.graylog.security.authservice.ProvisionerService;
import org.graylog.security.authservice.UserDetails;
import org.graylog.security.authservice.backend.LDAPAuthServiceBackendConfig;
import org.graylog.security.authservice.ldap.LDAPConnectorConfig;
import org.graylog.security.authservice.ldap.LDAPUser;
import org.graylog.security.authservice.ldap.UnboundLDAPConfig;
import org.graylog.security.authservice.ldap.UnboundLDAPConnector;
import org.graylog.security.authservice.test.AuthServiceBackendTestResult;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.shared.security.AuthenticationServiceUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPAuthServiceBackend
implements AuthServiceBackend {
    public static final String TYPE_NAME = "ldap";
    private static final Logger LOG = LoggerFactory.getLogger(LDAPAuthServiceBackend.class);
    private final LDAPAuthServiceBackendConfig config;
    private final UnboundLDAPConnector ldapConnector;
    private final AuthServiceBackendDTO backend;

    @Inject
    public LDAPAuthServiceBackend(UnboundLDAPConnector ldapConnector, @Assisted AuthServiceBackendDTO backend) {
        this.ldapConnector = ldapConnector;
        this.backend = backend;
        this.config = (LDAPAuthServiceBackendConfig)backend.config();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<AuthenticationDetails> authenticateAndProvision(AuthServiceCredentials authCredentials, ProvisionerService provisionerService) {
        try (LDAPConnection connection = this.ldapConnector.connect(this.config.getLDAPConnectorConfig());){
            if (connection == null) {
                Optional<AuthenticationDetails> optional = Optional.empty();
                return optional;
            }
            Optional<LDAPUser> optionalUser = this.findUser(connection, authCredentials);
            if (!optionalUser.isPresent()) {
                LOG.debug("User <{}> not found in LDAP", (Object)authCredentials.username());
                Optional<AuthenticationDetails> optional = Optional.empty();
                return optional;
            }
            LDAPUser userEntry = optionalUser.get();
            if (!authCredentials.isAuthenticated() && !this.isAuthenticated(connection, userEntry, authCredentials)) {
                LOG.debug("Invalid credentials for user <{}> (DN: {})", (Object)authCredentials.username(), (Object)userEntry.dn());
                Optional<AuthenticationDetails> optional = Optional.empty();
                return optional;
            }
            UserDetails userDetails = provisionerService.provision(provisionerService.newDetails(this).authServiceType(this.backendType()).authServiceId(this.backendId()).accountIsEnabled(true).base64AuthServiceUid(userEntry.base64UniqueId()).username(userEntry.username()).fullName(userEntry.fullName()).email(userEntry.email()).defaultRoles(this.backend.defaultRoles()).build());
            Optional<AuthenticationDetails> optional = Optional.of(AuthenticationDetails.builder().userDetails(userDetails).build());
            return optional;
        }
        catch (GeneralSecurityException e) {
            LOG.error("Error setting up TLS connection", (Throwable)e);
            throw new AuthenticationServiceUnavailableException("Error setting up TLS connection", e);
        }
        catch (LDAPException e) {
            LOG.error("LDAP error", (Throwable)e);
            throw new AuthenticationServiceUnavailableException("LDAP error", e);
        }
    }

    private boolean isAuthenticated(LDAPConnection connection, LDAPUser user, AuthServiceCredentials authCredentials) throws LDAPException {
        return this.ldapConnector.authenticate(connection, user.dn(), authCredentials.password());
    }

    private Optional<LDAPUser> findUser(LDAPConnection connection, AuthServiceCredentials authCredentials) throws LDAPException {
        UnboundLDAPConfig searchConfig = UnboundLDAPConfig.builder().userSearchBase(this.config.userSearchBase()).userSearchPattern(this.config.userSearchPattern()).userUniqueIdAttribute(this.config.userUniqueIdAttribute()).userNameAttribute(this.config.userNameAttribute()).userFullNameAttribute(this.config.userFullNameAttribute()).emailAttributes((List<String>)this.config.emailAttributes()).build();
        return this.ldapConnector.searchUserByPrincipal(connection, searchConfig, authCredentials.username());
    }

    @Override
    public String backendType() {
        return TYPE_NAME;
    }

    @Override
    public String backendId() {
        return this.backend.id();
    }

    @Override
    public String backendTitle() {
        return this.backend.title();
    }

    @Override
    public AuthServiceBackendDTO prepareConfigUpdate(AuthServiceBackendDTO existingBackend, AuthServiceBackendDTO newBackend) {
        LDAPAuthServiceBackendConfig newConfig = (LDAPAuthServiceBackendConfig)newBackend.config();
        if (newConfig.systemUserPassword().isDeleteValue()) {
            return newBackend.toBuilder().config(newConfig.toBuilder().systemUserPassword(EncryptedValue.createUnset()).build()).build();
        }
        if (newConfig.systemUserPassword().isKeepValue()) {
            LDAPAuthServiceBackendConfig existingConfig = (LDAPAuthServiceBackendConfig)existingBackend.config();
            return newBackend.toBuilder().config(newConfig.toBuilder().systemUserPassword(existingConfig.systemUserPassword()).build()).build();
        }
        return newBackend;
    }

    @Override
    public AuthServiceBackendTestResult testConnection(@Nullable AuthServiceBackendDTO existingBackendConfig) {
        LDAPAuthServiceBackendConfig testConfig = this.buildTestConfig(existingBackendConfig);
        LDAPConnectorConfig config = testConfig.getLDAPConnectorConfig();
        if (config.serverList().size() == 1) {
            return this.testSingleConnection(config, (LDAPConnectorConfig.LDAPServer)config.serverList().get(0));
        }
        List testResults = config.serverList().stream().map(server -> this.testSingleConnection(config, (LDAPConnectorConfig.LDAPServer)server)).collect(Collectors.toList());
        if (testResults.stream().anyMatch(res -> !res.isSuccess())) {
            return AuthServiceBackendTestResult.createFailure("Test failure", testResults.stream().map(r -> {
                if (r.isSuccess()) {
                    return r.message();
                }
                return r.message() + " : " + String.join((CharSequence)",", r.errors());
            }).collect(Collectors.toList()));
        }
        return AuthServiceBackendTestResult.createSuccess("Successfully connected to " + config.serverList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthServiceBackendTestResult testSingleConnection(LDAPConnectorConfig config, LDAPConnectorConfig.LDAPServer server) {
        LDAPConnectorConfig singleServerConfig = config.toBuilder().serverList((List<LDAPConnectorConfig.LDAPServer>)ImmutableList.of((Object)server)).build();
        try (LDAPConnection connection = this.ldapConnector.connect(singleServerConfig);){
            if (connection == null) {
                AuthServiceBackendTestResult authServiceBackendTestResult2 = AuthServiceBackendTestResult.createFailure("Couldn't establish connection to " + server);
                return authServiceBackendTestResult2;
            }
            AuthServiceBackendTestResult authServiceBackendTestResult = AuthServiceBackendTestResult.createSuccess("Successfully connected to " + server);
            return authServiceBackendTestResult;
        }
        catch (Exception e) {
            return AuthServiceBackendTestResult.createFailure("Couldn't establish connection to " + server, Collections.singletonList(e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuthServiceBackendTestResult testLogin(AuthServiceCredentials credentials, @Nullable AuthServiceBackendDTO existingBackendConfig) {
        LDAPAuthServiceBackendConfig testConfig = this.buildTestConfig(existingBackendConfig);
        try (LDAPConnection connection = this.ldapConnector.connect(testConfig.getLDAPConnectorConfig());){
            if (connection == null) {
                AuthServiceBackendTestResult authServiceBackendTestResult = AuthServiceBackendTestResult.createFailure("Couldn't establish connection to " + testConfig.servers());
                return authServiceBackendTestResult;
            }
            Optional<LDAPUser> user = this.findUser(connection, credentials);
            if (!user.isPresent()) {
                AuthServiceBackendTestResult authServiceBackendTestResult = AuthServiceBackendTestResult.createFailure("User <" + credentials.username() + "> doesn't exist", this.createTestResult(testConfig, false, false, null));
                return authServiceBackendTestResult;
            }
            if (this.isAuthenticated(connection, user.get(), credentials)) {
                AuthServiceBackendTestResult authServiceBackendTestResult = AuthServiceBackendTestResult.createSuccess("Successfully logged in <" + credentials.username() + "> into " + testConfig.servers(), this.createTestResult(testConfig, true, true, user.get()));
                return authServiceBackendTestResult;
            }
            AuthServiceBackendTestResult authServiceBackendTestResult = AuthServiceBackendTestResult.createFailure("Login for user <" + credentials.username() + "> failed", this.createTestResult(testConfig, true, false, user.get()));
            return authServiceBackendTestResult;
        }
        catch (Exception e) {
            return AuthServiceBackendTestResult.createFailure("Couldn't test user login on " + testConfig.servers(), Collections.singletonList(e.getMessage()));
        }
    }

    private LDAPAuthServiceBackendConfig buildTestConfig(@Nullable AuthServiceBackendDTO existingBackendConfig) {
        LDAPAuthServiceBackendConfig.Builder newConfigBuilder = this.config.toBuilder();
        if (this.config.systemUserPassword().isKeepValue() && existingBackendConfig != null) {
            LDAPAuthServiceBackendConfig existingConfig = (LDAPAuthServiceBackendConfig)existingBackendConfig.config();
            newConfigBuilder.systemUserPassword(existingConfig.systemUserPassword());
        }
        return newConfigBuilder.build();
    }

    private Map<String, Object> createTestResult(LDAPAuthServiceBackendConfig config, boolean userExists, boolean loginSuccess, @Nullable LDAPUser user) {
        ImmutableMap.Builder userDetails = ImmutableMap.builder().put((Object)"user_exists", (Object)userExists).put((Object)"login_success", (Object)loginSuccess);
        if (user != null) {
            HashMap<Object, String> attributes = new HashMap<Object, String>();
            attributes.put("dn", user.dn());
            attributes.put("unique_id (" + config.userUniqueIdAttribute() + ")", user.base64UniqueId());
            attributes.put(config.userNameAttribute(), user.username());
            attributes.put(config.userFullNameAttribute(), user.fullName());
            attributes.put("email", user.email());
            userDetails.put((Object)"user_details", (Object)ImmutableMap.copyOf(attributes));
        } else {
            userDetails.put((Object)"user_details", (Object)ImmutableMap.of());
        }
        return userDetails.build();
    }

    public static interface Factory
    extends AuthServiceBackend.Factory<LDAPAuthServiceBackend> {
        @Override
        public LDAPAuthServiceBackend create(AuthServiceBackendDTO var1);
    }
}

