/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.DBAuthServiceBackendService;
import org.graylog.security.authservice.GlobalAuthServiceConfig;
import org.graylog2.shared.rest.resources.RestResource;

@Path(value="/system/authentication/services")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="System/Authentication/Services", description="Manage authentication services")
@RequiresAuthentication
public class AuthServicesResource
extends RestResource {
    private final GlobalAuthServiceConfig authServiceConfig;
    private final DBAuthServiceBackendService backendService;

    @Inject
    public AuthServicesResource(GlobalAuthServiceConfig authServiceConfig, DBAuthServiceBackendService backendService) {
        this.authServiceConfig = authServiceConfig;
        this.backendService = backendService;
    }

    @GET
    @Path(value="active-backend")
    @ApiOperation(value="Get active authentication service backend")
    @RequiresPermissions(value={"authserviceglobalconfig:read"})
    public Response get() {
        Optional<AuthServiceBackendDTO> activeConfig = this.getActiveBackendConfig();
        HashMap<String, Map<String, Long>> response = new HashMap<String, Map<String, Long>>();
        response.put("backend", activeConfig.orElse(null));
        response.put("context", Collections.singletonMap("backends_total", this.backendService.countBackends()));
        return Response.ok(response).build();
    }

    private Optional<AuthServiceBackendDTO> getActiveBackendConfig() {
        Optional<AuthServiceBackendDTO> activeConfig = this.authServiceConfig.getActiveBackendConfig();
        activeConfig.ifPresent(backend -> this.checkPermission("authservicebackend:read", backend.id()));
        return activeConfig;
    }
}

