/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.test;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.security.authservice.test.AutoValue_AuthServiceBackendTestResult;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AuthServiceBackendTestResult {
    private static final String FIELD_IS_SUCCESS = "success";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_ERRORS = "errors";
    private static final String FIELD_RESULT = "result";

    @JsonProperty(value="success")
    public abstract boolean isSuccess();

    @JsonProperty(value="message")
    public abstract String message();

    @JsonProperty(value="errors")
    public abstract ImmutableList<String> errors();

    @JsonProperty(value="result")
    public abstract ImmutableMap<String, Object> result();

    public static AuthServiceBackendTestResult createSuccess(String message) {
        return AuthServiceBackendTestResult.builder().isSuccess(true).message(message).build();
    }

    public static AuthServiceBackendTestResult createSuccess(String message, Map<String, Object> result) {
        return AuthServiceBackendTestResult.builder().isSuccess(true).message(message).result(result).build();
    }

    public static AuthServiceBackendTestResult createFailure(String message) {
        return AuthServiceBackendTestResult.builder().isSuccess(false).message(message).build();
    }

    public static AuthServiceBackendTestResult createFailure(String message, List<String> errors) {
        return AuthServiceBackendTestResult.builder().isSuccess(false).message(message).errors(errors).build();
    }

    public static AuthServiceBackendTestResult createFailure(String message, Map<String, Object> result) {
        return AuthServiceBackendTestResult.builder().isSuccess(false).message(message).result(result).build();
    }

    public static AuthServiceBackendTestResult createFailure(String message, List<String> errors, Map<String, Object> result) {
        return AuthServiceBackendTestResult.builder().isSuccess(false).message(message).errors(errors).result(result).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_AuthServiceBackendTestResult.Builder().errors(Collections.emptyList()).result(Collections.emptyMap());
        }

        @JsonProperty(value="success")
        public abstract Builder isSuccess(boolean var1);

        @JsonProperty(value="message")
        public abstract Builder message(String var1);

        @JsonProperty(value="errors")
        public abstract Builder errors(List<String> var1);

        @JsonProperty(value="result")
        public abstract Builder result(Map<String, Object> var1);

        public abstract AuthServiceBackendTestResult build();
    }
}

