/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.graylog.security.certutil.CertRequest;
import org.graylog.security.certutil.CertificateGenerator;
import org.graylog.security.certutil.KeyPair;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.SystemConsole;
import org.graylog2.bootstrap.CliCommand;
import org.graylog2.plugin.Tools;
import org.graylog2.shared.SuppressForbidden;

@Command(name="http", description="Manage certificates for data-node", groupNames={"certutil"})
public class CertutilHttp
implements CliCommand {
    @Deprecated
    public static final String DATANODE_KEY_ALIAS = "datanode";
    @Option(name={"--ca"}, description="Filename for the CA keystore")
    protected String caKeystoreFilename = "datanode-ca.p12";
    @Option(name={"--keystore"}, description="Filename for the generated HTTP keystore")
    protected String nodeKeystoreFilename = "datanode-http-certificates.p12";
    private final CommandLineConsole console;
    public static final CommandLineConsole.Prompt PROMPT_USE_OWN_CERTIFICATE_AUTHORITY = CommandLineConsole.prompt("Do you want to use your own certificate authority? Respond with y/n?");
    public static final CommandLineConsole.Prompt PROMPT_ENTER_CA_PASSWORD = CommandLineConsole.prompt("Enter CA password: ");
    public static final CommandLineConsole.Prompt PROMPT_ENTER_CERTIFICATE_VALIDITY_IN_DAYS = CommandLineConsole.prompt("Enter certificate validity in days: ");
    public static final CommandLineConsole.Prompt PROMPT_ENTER_CERTIFICATE_ALTERNATIVE_NAMES = CommandLineConsole.prompt("Enter alternative names (addresses) of this node [comma separated]: ");
    public static final CommandLineConsole.Prompt PROMPT_ENTER_HTTP_CERTIFICATE_PASSWORD = CommandLineConsole.prompt("Enter HTTP certificate password: ");

    public CertutilHttp() {
        this.console = new SystemConsole();
    }

    public CertutilHttp(String caKeystoreFilename, String nodeKeystoreFilename, CommandLineConsole console) {
        this.caKeystoreFilename = caKeystoreFilename;
        this.nodeKeystoreFilename = nodeKeystoreFilename;
        this.console = console;
    }

    @Override
    @SuppressForbidden(value="DNS Lookup intentional.")
    public void run() {
        this.console.printLine("This tool will generate a data-node certificate for HTTP communication (REST API)");
        boolean useOwnCertificateEntity = this.console.readBoolean(PROMPT_USE_OWN_CERTIFICATE_AUTHORITY);
        if (useOwnCertificateEntity) {
            try {
                this.console.printLine("Generating certificate signing request for this datanode");
                CertRequest certReq = CertRequest.selfSigned("localhost");
                KeyPair keyPair = CertificateGenerator.generate(certReq);
                JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(new X500Principal("CN=Requested Test Certificate"), keyPair.publicKey());
                JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder("SHA256withRSA");
                ContentSigner signer = csBuilder.build(keyPair.privateKey());
                PKCS10CertificationRequest csr = p10Builder.build(signer);
                Path csrPath = Path.of("datanode.csr", new String[0]);
                CertutilHttp.writePem(csrPath, csr);
                this.console.printLine("CSR written to file " + csrPath.toAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.console.printLine("Generating a HTTP certificate signed by the datanode CA");
        Path caKeystorePath = Path.of(this.caKeystoreFilename, new String[0]);
        this.console.printLine("Using certificate authority " + caKeystorePath.toAbsolutePath());
        try {
            char[] password = this.console.readPassword(PROMPT_ENTER_CA_PASSWORD);
            KeyStore caKeystore = KeyStore.getInstance("PKCS12");
            caKeystore.load(new FileInputStream(this.caKeystoreFilename), password);
            PrivateKey caPrivateKey = (PrivateKey)caKeystore.getKey("ca", password);
            X509Certificate caCertificate = (X509Certificate)caKeystore.getCertificate("ca");
            KeyPair caKeyPair = new KeyPair(caPrivateKey, null, caCertificate);
            int validityDays = this.console.readInt(PROMPT_ENTER_CERTIFICATE_VALIDITY_IN_DAYS);
            String cnName = Tools.getLocalCanonicalHostname();
            CertRequest certificateRequest = CertRequest.signed(cnName, caKeyPair).withSubjectAlternativeName("localhost").withSubjectAlternativeName(Tools.getLocalHostname()).withSubjectAlternativeName(String.valueOf(InetAddress.getLocalHost())).withSubjectAlternativeName("127.0.0.1").withSubjectAlternativeName("ip6-localhost").validity(Duration.ofDays(validityDays));
            String alternativeNames = this.console.readLine(PROMPT_ENTER_CERTIFICATE_ALTERNATIVE_NAMES);
            Arrays.stream(alternativeNames.split(",")).filter(StringUtils::isNotBlank).forEach(certificateRequest::withSubjectAlternativeName);
            this.console.printLine(String.format(Locale.ROOT, "Generating certificate for CN=%s, with validity %d days and subject alternative names %s", cnName, certificateRequest.validity().toDays(), certificateRequest.subjectAlternativeNames()));
            KeyPair nodePair = CertificateGenerator.generate(certificateRequest);
            this.console.printLine("Successfully generated CA from the keystore");
            KeyStore nodeKeystore = KeyStore.getInstance("PKCS12");
            nodeKeystore.load(null, null);
            char[] nodeKeystorePassword = this.console.readPassword(PROMPT_ENTER_HTTP_CERTIFICATE_PASSWORD);
            nodeKeystore.setKeyEntry(DATANODE_KEY_ALIAS, nodePair.privateKey(), nodeKeystorePassword, new X509Certificate[]{nodePair.certificate(), caKeyPair.certificate()});
            Path nodeKeystorePath = Path.of(this.nodeKeystoreFilename, new String[0]);
            try (FileOutputStream store = new FileOutputStream(nodeKeystorePath.toFile());){
                nodeKeystore.store(store, nodeKeystorePassword);
                this.console.printLine("Private key and certificate for this datanode HTTP successfully saved into " + nodeKeystorePath.toAbsolutePath());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void writePem(Path path, Object object) throws IOException {
        FileWriter writer = new FileWriter(path.toFile(), StandardCharsets.UTF_8);
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        pemWriter.writeObject(object);
        pemWriter.flush();
        pemWriter.close();
    }
}

