/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.csr;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog.security.certutil.CaService;
import org.graylog.security.certutil.csr.ClientCert;
import org.graylog.security.certutil.csr.CsrGenerator;
import org.graylog.security.certutil.csr.CsrSigner;
import org.graylog.security.certutil.csr.exceptions.ClientCertGenerationException;
import org.graylog.security.certutil.privatekey.PrivateKeyEncryptedFileStorage;
import org.graylog2.indexer.security.SecurityAdapter;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.graylog2.plugin.cluster.ClusterConfigService;

public class ClientCertGenerator {
    private final CaService caService;
    private final String passwordSecret;
    private final CsrGenerator csrGenerator;
    private final CsrSigner csrSigner;
    private final ClusterConfigService clusterConfigService;
    private final SecurityAdapter securityAdapter;
    private final Path dataDir;

    @Inject
    public ClientCertGenerator(CaService caService, @Named(value="password_secret") String passwordSecret, @Named(value="data_dir") Path dataDir, CsrGenerator csrGenerator, CsrSigner csrSigner, ClusterConfigService clusterConfigService, SecurityAdapter securityAdapter) {
        this.caService = caService;
        this.passwordSecret = passwordSecret;
        this.csrGenerator = csrGenerator;
        this.csrSigner = csrSigner;
        this.clusterConfigService = clusterConfigService;
        this.securityAdapter = securityAdapter;
        this.dataDir = dataDir;
    }

    private Path certFilePath(String role, String principal) {
        String certfile = Base64.getEncoder().encodeToString((role + ":" + principal).getBytes(StandardCharsets.UTF_8));
        return this.dataDir.resolve(Path.of(certfile + ".cert", new String[0]));
    }

    private String c(Object o) throws IOException {
        StringWriter writer = new StringWriter();
        try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)writer);){
            jcaPEMWriter.writeObject(o);
        }
        return writer.toString();
    }

    public ClientCert generateClientCert(String principal, String role, char[] privateKeyPassword) throws ClientCertGenerationException {
        try {
            RenewalPolicy renewalPolicy = this.clusterConfigService.get(RenewalPolicy.class);
            PrivateKeyEncryptedFileStorage privateKeyEncryptedStorage = new PrivateKeyEncryptedFileStorage(this.certFilePath(role, principal));
            Optional<KeyStore> optKey = this.caService.loadKeyStore();
            KeyStore caKeystore = optKey.get();
            PrivateKey caPrivateKey = (PrivateKey)caKeystore.getKey("ca", this.passwordSecret.toCharArray());
            X509Certificate caCertificate = (X509Certificate)caKeystore.getCertificate("ca");
            PKCS10CertificationRequest csr = this.csrGenerator.generateCSR(privateKeyPassword, principal, List.of(principal), privateKeyEncryptedStorage);
            PrivateKey pk = privateKeyEncryptedStorage.readEncryptedKey(privateKeyPassword);
            X509Certificate cert = this.csrSigner.sign(caPrivateKey, caCertificate, csr, renewalPolicy);
            this.securityAdapter.addUserToRoleMapping(role, principal);
            return new ClientCert(principal, role, this.c(caCertificate), this.c(pk), this.c(cert));
        }
        catch (Exception e) {
            throw new ClientCertGenerationException("Failed to generate client certificate", e);
        }
    }

    public void removeCertFor(String role, String principal) throws IOException {
        Path certFile = this.certFilePath(role, principal);
        if (Files.exists(certFile, new LinkOption[0])) {
            Files.delete(certFile);
            this.securityAdapter.removeUserFromRoleMapping(role, principal);
        }
    }
}

