/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.csr.storage;

import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;

public class CsrMongoStorage {
    private DataNodeProvisioningService mongoService;

    @Inject
    public CsrMongoStorage(DataNodeProvisioningService mongoService) {
        this.mongoService = mongoService;
    }

    public void writeCsr(PKCS10CertificationRequest csr, String nodeId) throws IOException, OperatorException {
        try (StringWriter writer = new StringWriter();){
            try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)writer);){
                jcaPEMWriter.writeObject((Object)csr);
            }
            this.mongoService.writeCsr(nodeId, writer.toString());
        }
    }

    public Optional<PKCS10CertificationRequest> readCsr(String nodeId) throws IOException {
        Optional nodeCsr = this.mongoService.getPreflightConfigFor(nodeId).flatMap(cfg -> Optional.ofNullable(cfg.csr()));
        if (nodeCsr.isEmpty()) {
            return Optional.empty();
        }
        String csr = (String)nodeCsr.get();
        BufferedReader pemReader = new BufferedReader(new StringReader(csr));
        PEMParser pemParser = new PEMParser((Reader)pemReader);
        Object parsedObj = pemParser.readObject();
        if (parsedObj instanceof PKCS10CertificationRequest) {
            return Optional.of((PKCS10CertificationRequest)parsedObj);
        }
        return Optional.empty();
    }
}

