/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.keystore.storage;

import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyStore;
import java.util.Base64;
import java.util.Optional;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog.security.certutil.keystore.storage.KeystoreContentMover;
import org.graylog.security.certutil.keystore.storage.KeystoreStorage;
import org.graylog.security.certutil.keystore.storage.location.KeystoreMongoLocation;
import org.graylog2.cluster.certificates.CertificatesService;

public final class KeystoreMongoStorage
implements KeystoreStorage<KeystoreMongoLocation> {
    private final CertificatesService certificatesService;
    private final KeystoreContentMover keystoreContentMover;

    @Inject
    public KeystoreMongoStorage(CertificatesService certificatesService, KeystoreContentMover keystoreContentMover) {
        this.certificatesService = certificatesService;
        this.keystoreContentMover = keystoreContentMover;
    }

    @Override
    public void writeKeyStore(KeystoreMongoLocation location, KeyStore keyStore, char[] currentPassword, char[] newPassword) throws KeyStoreStorageException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            if (newPassword == null) {
                keyStore.store(baos, currentPassword);
            } else {
                KeyStore newKeyStore = this.keystoreContentMover.moveContents(keyStore, currentPassword, newPassword);
                newKeyStore.store(baos, newPassword);
            }
            String keystoreDataAsString = Base64.getEncoder().encodeToString(baos.toByteArray());
            this.certificatesService.writeCert(location, keystoreDataAsString);
        }
        catch (Exception ex) {
            throw new KeyStoreStorageException("Failed to save keystore to Mongo collection for node " + location.nodeId(), ex);
        }
    }

    @Override
    public Optional<KeyStore> readKeyStore(KeystoreMongoLocation location, char[] password) throws KeyStoreStorageException {
        Optional<String> keystoreAsString = this.certificatesService.readCert(location);
        if (keystoreAsString.isPresent()) {
            Optional<KeyStore> optional;
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(keystoreAsString.get()));
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(bais, password);
                optional = Optional.of(keyStore);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bais.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new KeyStoreStorageException("Failed to load keystore from Mongo collection for node " + location.nodeId(), ex);
                }
            }
            bais.close();
            return optional;
        }
        return Optional.empty();
    }
}

