/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ReflectionUtils;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graylog2.bindings.NamedBindingOverride;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedConfigParametersOverrideModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(NamedConfigParametersOverrideModule.class);
    private final Set<Object> beans;
    private final boolean registerBeans;

    public NamedConfigParametersOverrideModule(Collection<?> beans, boolean registerBeans) {
        this.beans = new HashSet(beans);
        this.registerBeans = registerBeans;
    }

    public NamedConfigParametersOverrideModule(Collection<?> beans) {
        this(beans, true);
    }

    protected void configure() {
        if (this.registerBeans) {
            this.registerBeanInstances();
        }
        for (Object bean : this.beans) {
            this.registerParameters(bean);
        }
    }

    private void registerParameters(Object bean) {
        Field[] fields = ReflectionUtils.getAllFields(bean.getClass());
        Map methodOverrides = org.reflections.ReflectionUtils.getAllMethods(bean.getClass(), (Predicate[])new Predicate[0]).stream().filter(obj -> Objects.nonNull(obj.getAnnotation(NamedBindingOverride.class))).collect(Collectors.toMap(obj -> obj.getAnnotation(NamedBindingOverride.class).value(), Function.identity()));
        for (Field field : fields) {
            Parameter parameter = field.getAnnotation(Parameter.class);
            if (parameter != null) {
                try {
                    TypeLiteral typeLiteral = TypeLiteral.get((Type)field.getGenericType());
                    Object value = ReflectionUtils.getFieldValue((Object)bean, (Field)field);
                    String parameterName = parameter.value();
                    if (methodOverrides.containsKey(parameterName)) {
                        Method method = (Method)methodOverrides.get(parameterName);
                        TypeLiteral methodTypeLiteral = TypeLiteral.get((Type)method.getGenericReturnType());
                        if (!typeLiteral.equals((Object)methodTypeLiteral)) {
                            throw new IllegalStateException(StringUtils.f("Parameter %s type mismatch @%s#%s <> @%s#%s", parameterName, NamedBindingOverride.class.getSimpleName(), methodTypeLiteral, Parameter.class.getSimpleName(), typeLiteral));
                        }
                        value = org.reflections.ReflectionUtils.invoke((Method)method, (Object)bean, (Object[])new Object[0]);
                    }
                    if (value == null) {
                        this.bind(typeLiteral).annotatedWith((Annotation)Names.named((String)parameterName)).toProvider(Providers.of(null));
                        continue;
                    }
                    this.bind(typeLiteral).annotatedWith((Annotation)Names.named((String)parameterName)).toInstance(value);
                }
                catch (IllegalAccessException e) {
                    LOG.warn("Couldn't bind \"" + field.getName() + "\"", (Throwable)e);
                }
                continue;
            }
            LOG.debug("Skipping field {}", (Object)field.getName());
        }
    }

    private void registerBeanInstances() {
        for (Object bean : this.beans) {
            TypeLiteral typeLiteral = TypeLiteral.get(bean.getClass());
            this.bind(typeLiteral).toInstance(bean);
        }
    }
}

