/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap;

import com.github.rvesse.airline.annotations.Option;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.graylog2.Configuration;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.bindings.ConfigurationModule;
import org.graylog2.bindings.NamedConfigParametersOverrideModule;
import org.graylog2.bootstrap.CmdLineTool;
import org.graylog2.bootstrap.Main;
import org.graylog2.bootstrap.preflight.MongoDBPreflightCheck;
import org.graylog2.bootstrap.preflight.PreflightCheckException;
import org.graylog2.bootstrap.preflight.PreflightCheckService;
import org.graylog2.bootstrap.preflight.PreflightWebModule;
import org.graylog2.bootstrap.preflight.ServerPreflightChecksModule;
import org.graylog2.bootstrap.preflight.web.PreflightBoot;
import org.graylog2.cluster.leader.LeaderElectionService;
import org.graylog2.cluster.preflight.DataNodeProvisioningBindings;
import org.graylog2.configuration.IndexerDiscoveryModule;
import org.graylog2.configuration.PathConfiguration;
import org.graylog2.configuration.TLSProtocolsConfiguration;
import org.graylog2.migrations.Migration;
import org.graylog2.migrations.MigrationType;
import org.graylog2.plugin.MessageBindings;
import org.graylog2.plugin.Plugin;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.bindings.FreshInstallDetectionModule;
import org.graylog2.shared.bindings.GenericBindings;
import org.graylog2.shared.bindings.GenericInitializerBindings;
import org.graylog2.shared.bindings.GuiceInjectorHolder;
import org.graylog2.shared.bindings.IsDevelopmentBindings;
import org.graylog2.shared.bindings.ObjectMapperModule;
import org.graylog2.shared.bindings.SchedulerBindings;
import org.graylog2.shared.bindings.ServerStatusBindings;
import org.graylog2.shared.bindings.SharedPeriodicalBindings;
import org.graylog2.shared.bindings.ValidatorModule;
import org.graylog2.shared.initializers.ServiceManagerListener;
import org.graylog2.shared.plugins.ChainingClassLoader;
import org.graylog2.shared.security.CertificateRenewalBindings;
import org.graylog2.shared.security.SecurityBindings;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.shared.system.stats.SystemStatsModule;
import org.jsoftbiz.utils.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerBootstrap
extends CmdLineTool {
    private static final Logger LOG = LoggerFactory.getLogger(ServerBootstrap.class);
    private boolean isFreshInstallation;
    @Option(name={"-p", "--pidfile"}, description="File containing the PID of Graylog")
    private String pidFile = TMPDIR + FILE_SEPARATOR + "graylog.pid";
    @Option(name={"-np", "--no-pid-file"}, description="Do not write a PID file (overrides -p/--pidfile)")
    private boolean noPidFile = false;

    protected ServerBootstrap(String commandName, Configuration configuration) {
        super(commandName, configuration);
        this.commandName = commandName;
    }

    protected abstract void startNodeRegistration(Injector var1);

    public String getPidFile() {
        return this.pidFile;
    }

    public boolean isNoPidFile() {
        return this.noPidFile;
    }

    private boolean isFreshInstallation() {
        return this.isFreshInstallation;
    }

    private void registerFreshInstallation() {
        this.isFreshInstallation = true;
    }

    @Override
    protected void beforeStart(TLSProtocolsConfiguration tlsProtocolsConfiguration, PathConfiguration pathConfiguration) {
        super.beforeStart(tlsProtocolsConfiguration, pathConfiguration);
        if (!this.isNoPidFile()) {
            this.savePidFile(this.getPidFile());
        }
        ServerBootstrap.applySecuritySettings(tlsProtocolsConfiguration);
        this.setNettyNativeDefaults(pathConfiguration);
    }

    @Override
    protected void beforeInjectorCreation(Set<Plugin> plugins) {
        this.runPreFlightChecks(plugins);
    }

    private void runPreFlightChecks(Set<Plugin> plugins) {
        if (this.configuration.getSkipPreflightChecks()) {
            LOG.info("Skipping preflight checks");
            return;
        }
        this.runMongoPreflightCheck();
        List<Module> preflightCheckModules = plugins.stream().map(Plugin::preflightCheckModules).flatMap(Collection::stream).collect(Collectors.toList());
        preflightCheckModules.add(new FreshInstallDetectionModule(this.isFreshInstallation()));
        if (this.featureFlags.isOn("preflight_web")) {
            this.runPreflightWeb(preflightCheckModules);
        }
        Injector preflightInjector = this.getPreflightInjector(preflightCheckModules);
        PreflightCheckService preflightCheckService = (PreflightCheckService)preflightInjector.getInstance(PreflightCheckService.class);
        preflightCheckService.runChecks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPreflightWeb(List<Module> preflightCheckModules) {
        ArrayList<Module> modules = new ArrayList<Module>(preflightCheckModules);
        modules.add((Module)new DataNodeProvisioningBindings());
        modules.add((Module)new PreflightWebModule(this.configuration));
        modules.add((Module)new ObjectMapperModule(this.chainingClassLoader));
        modules.add((Module)new SchedulerBindings());
        modules.add(binder -> binder.bind(ChainingClassLoader.class).toInstance((Object)this.chainingClassLoader));
        Injector preflightInjector = this.getPreflightInjector(modules);
        GuiceInjectorHolder.setInjector(preflightInjector);
        try {
            this.doRunWithPreflightInjector(preflightInjector);
        }
        finally {
            GuiceInjectorHolder.resetInjector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doRunWithPreflightInjector(Injector preflightInjector) {
        PreflightBoot preflightBoot = (PreflightBoot)preflightInjector.getInstance(PreflightBoot.class);
        if (!preflightBoot.shouldRunPreflightWeb()) {
            return;
        }
        LOG.info("Fresh installation detected, starting configuration webserver");
        try {
            if (this.configuration.isLeader() && this.configuration.runMigrations()) {
                this.runMigrations(preflightInjector, MigrationType.PREFLIGHT);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while running migrations", (Throwable)e);
            System.exit(1);
        }
        ServiceManager serviceManager = (ServiceManager)preflightInjector.getInstance(ServiceManager.class);
        LeaderElectionService leaderElectionService = (LeaderElectionService)preflightInjector.getInstance(LeaderElectionService.class);
        try {
            leaderElectionService.startAsync().awaitRunning();
            serviceManager.startAsync().awaitHealthy();
            while (preflightBoot.shouldRunPreflightWeb()) {
                try {
                    LOG.debug("Preflight config still in progress, waiting for the marker document");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            boolean isLeader = leaderElectionService.isLeader();
            serviceManager.stopAsync().awaitStopped();
            leaderElectionService.stopAsync().awaitTerminated();
            try {
                if (!isLeader) {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Tried to wait for a bit before resuming but got interrupted. Resuming anyway now. Error was: {}", (Object)e.getMessage());
            }
        }
    }

    private void runMongoPreflightCheck() {
        Injector injector = this.getMongoPreFlightInjector();
        MongoDBPreflightCheck mongoDBPreflightCheck = (MongoDBPreflightCheck)injector.getInstance(MongoDBPreflightCheck.class);
        try {
            mongoDBPreflightCheck.runCheck();
        }
        catch (PreflightCheckException e) {
            LOG.error("Preflight check failed with error: {}", (Object)e.getLocalizedMessage());
            throw e;
        }
        if (mongoDBPreflightCheck.isFreshInstallation()) {
            this.registerFreshInstallation();
        }
    }

    private Injector getMongoPreFlightInjector() {
        return Guice.createInjector((Module[])new Module[]{new IsDevelopmentBindings(), new NamedConfigParametersOverrideModule(this.jadConfig.getConfigurationBeans()), new ConfigurationModule(this.configuration)});
    }

    private Injector getPreflightInjector(List<Module> preflightCheckModules) {
        return Guice.createInjector((Module[])new Module[]{new IsDevelopmentBindings(), new NamedConfigParametersOverrideModule(this.jadConfig.getConfigurationBeans()), new ServerStatusBindings(this.capabilities()), new ConfigurationModule(this.configuration), new SystemStatsModule(this.configuration.isDisableNativeSystemStatsCollector()), new IndexerDiscoveryModule(), new ServerPreflightChecksModule(), binder -> preflightCheckModules.forEach(arg_0 -> ((Binder)binder).install(arg_0))});
    }

    private void setNettyNativeDefaults(PathConfiguration pathConfiguration) {
        if (System.getProperty("io.netty.native.workdir") == null) {
            System.setProperty("io.netty.native.workdir", pathConfiguration.getNativeLibDir().toAbsolutePath().toString());
        }
        if (System.getProperty("io.netty.native.deleteLibAfterLoading") == null) {
            System.setProperty("io.netty.native.deleteLibAfterLoading", "false");
        }
    }

    @Override
    protected void startCommand() {
        Service leaderElectionService;
        ServiceManager serviceManager;
        ActivityWriter activityWriter;
        AuditEventSender auditEventSender = (AuditEventSender)this.injector.getInstance(AuditEventSender.class);
        NodeId nodeId = (NodeId)this.injector.getInstance(NodeId.class);
        String systemInformation = Tools.getSystemInformation();
        ImmutableMap auditEventContext = ImmutableMap.of((Object)"version", (Object)version.toString(), (Object)"java", (Object)systemInformation, (Object)"node_id", (Object)nodeId.getNodeId());
        auditEventSender.success(AuditActor.system(nodeId), "server:node_startup:initiate", (Map<String, Object>)auditEventContext);
        OS os = OS.getOs();
        LOG.info("Graylog {} {} starting up", (Object)this.commandName, (Object)version);
        LOG.info("JRE: {}", (Object)systemInformation);
        LOG.info("Deployment: {}", (Object)this.configuration.getInstallationSource());
        LOG.info("OS: {}", (Object)os.getPlatformName());
        LOG.info("Arch: {}", (Object)os.getArch());
        LOG.info("Node ID: {}", (Object)nodeId);
        try {
            if (this.configuration.isLeader() && this.configuration.runMigrations()) {
                this.runMigrations(this.injector, MigrationType.STANDARD);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while running migrations", (Throwable)e);
            System.exit(1);
        }
        ServerStatus serverStatus = (ServerStatus)this.injector.getInstance(ServerStatus.class);
        serverStatus.initialize();
        this.startNodeRegistration(this.injector);
        try {
            activityWriter = (ActivityWriter)this.injector.getInstance(ActivityWriter.class);
            serviceManager = (ServiceManager)this.injector.getInstance(ServiceManager.class);
            leaderElectionService = (Service)this.injector.getInstance(LeaderElectionService.class);
        }
        catch (ProvisionException e) {
            LOG.error("Guice error", (Throwable)e);
            this.annotateProvisionException(e);
            auditEventSender.failure(AuditActor.system(nodeId), "server:node_startup:initiate", (Map<String, Object>)auditEventContext);
            System.exit(-1);
            return;
        }
        catch (Exception e) {
            LOG.error("Unexpected exception", (Throwable)e);
            auditEventSender.failure(AuditActor.system(nodeId), "server:node_startup:initiate", (Map<String, Object>)auditEventContext);
            System.exit(-1);
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this.injector.getInstance(this.shutdownHook())));
        MessageInput.setDefaultRecvBufferSize(this.configuration.getUdpRecvBufferSizes());
        ServiceManagerListener serviceManagerListener = (ServiceManagerListener)((Object)this.injector.getInstance(ServiceManagerListener.class));
        serviceManager.addListener((ServiceManager.Listener)serviceManagerListener, MoreExecutors.directExecutor());
        try {
            leaderElectionService.startAsync().awaitRunning();
            serviceManager.startAsync().awaitHealthy();
        }
        catch (Exception e) {
            try {
                serviceManager.stopAsync().awaitStopped((long)this.configuration.getShutdownTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                LOG.error("Unable to shutdown properly on time. {}", (Object)serviceManager.servicesByState());
            }
            LOG.error("Graylog startup failed. Exiting. Exception was:", (Throwable)e);
            auditEventSender.failure(AuditActor.system(nodeId), "server:node_startup:initiate", (Map<String, Object>)auditEventContext);
            System.exit(-1);
        }
        LOG.info("Services started, startup times in ms: {}", (Object)serviceManager.startupTimes());
        activityWriter.write(new Activity("Started up.", Main.class));
        LOG.info("Graylog {} up and running.", (Object)this.commandName);
        auditEventSender.success(AuditActor.system(nodeId), "server:node_startup:complete", (Map<String, Object>)auditEventContext);
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void runMigrations(Injector injector, MigrationType migrationType) {
        TypeLiteral typeLiteral = TypeLiteral.get((Type)Types.setOf(Migration.class));
        Set migrations = (Set)injector.getInstance(Key.get((TypeLiteral)typeLiteral));
        LOG.info("Running {} migrations...", (Object)migrations.size());
        ImmutableSortedSet.copyOf((Collection)migrations).stream().filter(m -> m.migrationType() == migrationType).forEach(m -> {
            LOG.debug("Running migration <{}>", (Object)m.getClass().getCanonicalName());
            try {
                m.upgrade();
            }
            catch (Exception e) {
                if (this.configuration.ignoreMigrationFailures()) {
                    LOG.warn("Ignoring failure of migration <{}>: {}", (Object)m.getClass().getCanonicalName(), (Object)e.getMessage());
                }
                throw e;
            }
        });
    }

    protected void savePidFile(String pidFile) {
        String pid = Tools.getPID();
        Path pidFilePath = Paths.get(pidFile, new String[0]);
        pidFilePath.toFile().deleteOnExit();
        try {
            if (Strings.isNullOrEmpty((String)pid) || "unknown".equals(pid)) {
                throw new Exception("Could not determine PID.");
            }
            Files.write(pidFilePath, pid.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, LinkOption.NOFOLLOW_LINKS);
        }
        catch (Exception e) {
            LOG.error("Could not write PID file: " + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    protected List<Module> getSharedBindingsModules() {
        List<Module> result = super.getSharedBindingsModules();
        result.add(new FreshInstallDetectionModule(this.isFreshInstallation()));
        result.add((Module)new GenericBindings(this.isMigrationCommand()));
        result.add((Module)new MessageBindings());
        result.add((Module)new SecurityBindings());
        result.add((Module)new ServerStatusBindings(this.capabilities()));
        result.add((Module)new ValidatorModule());
        result.add((Module)new SharedPeriodicalBindings());
        result.add((Module)new SchedulerBindings());
        result.add((Module)new GenericInitializerBindings());
        result.add((Module)new SystemStatsModule(this.configuration.isDisableNativeSystemStatsCollector()));
        result.add((Module)new IndexerDiscoveryModule());
        result.add((Module)new CertificateRenewalBindings());
        result.add((Module)new DataNodeProvisioningBindings());
        return result;
    }

    protected void annotateProvisionException(ProvisionException e) {
        this.annotateInjectorExceptions(e.getErrorMessages());
        throw e;
    }

    protected abstract Class<? extends Runnable> shutdownHook();
}

