/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.commands;

import com.github.rvesse.airline.annotations.Command;
import org.graylog2.commands.Server;
import org.graylog2.migrations.MigrationType;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.Version;
import org.jsoftbiz.utils.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="migrate", description="Run Graylog server migrations")
public class MigrateCmd
extends Server {
    public static final String MIGRATION_COMMAND = "migrate";
    private static final Logger LOG = LoggerFactory.getLogger(MigrateCmd.class);
    private final Version version = Version.CURRENT_CLASSPATH;

    public MigrateCmd() {
        super(MIGRATION_COMMAND);
    }

    @Override
    protected void startCommand() {
        OS os = OS.getOs();
        LOG.info("Graylog {} {} migration command", (Object)this.commandName, (Object)this.version);
        LOG.info("JRE: {}", (Object)Tools.getSystemInformation());
        LOG.info("Deployment: {}", (Object)configuration.getInstallationSource());
        LOG.info("OS: {}", (Object)os.getPlatformName());
        LOG.info("Arch: {}", (Object)os.getArch());
        try {
            this.runMigrations(this.injector, MigrationType.STANDARD);
        }
        catch (Exception e) {
            LOG.warn("Exception while running migrations", (Throwable)e);
            System.exit(1);
        }
        System.exit(0);
    }
}

