/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.certutil.CertRenewalService;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;

@Api(value="Certificates")
@Path(value="/certrenewal")
@Produces(value={"application/json"})
@RequiresAuthentication
public class CertificateRenewalResource
implements PluginRestResource {
    private final CertRenewalService certRenewalService;

    @Inject
    public CertificateRenewalResource(CertRenewalService certRenewalService) {
        this.certRenewalService = certRenewalService;
    }

    @GET
    @RequiresPermissions(value={"clusterconfigentry:read"})
    public List<CertRenewalService.DataNode> listDataNodes() {
        return this.certRenewalService.findNodes();
    }

    @POST
    @Path(value="{nodeID}")
    @AuditEvent(type="server:certificate_renewal:manual")
    @RequiresPermissions(value={"clusterconfigentry:create", "clusterconfigentry:edit"})
    public void initiateCertRenewalForNode(@ApiParam(name="nodeID") @PathParam(value="nodeID") String nodeID) {
        this.certRenewalService.initiateRenewalForNode(nodeID);
    }
}

