/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentstream.db;

import jakarta.inject.Inject;
import java.util.Optional;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.contentstream.db.ContentStreamUserSettings;
import org.graylog2.database.MongoConnection;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class DBContentStreamUserSettingsService {
    public static final String COLLECTION_NAME = "content_stream_user_settings";
    private final JacksonDBCollection<ContentStreamUserSettings, ObjectId> db;

    @Inject
    public DBContentStreamUserSettingsService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.db = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection(COLLECTION_NAME), ContentStreamUserSettings.class, ObjectId.class, mapper.get());
    }

    public Optional<ContentStreamUserSettings> findByUserId(String userId) {
        return Optional.ofNullable(this.db.findOne((Bson)DBQuery.is((String)"user_id", (Object)userId)));
    }

    public void save(ContentStreamUserSettings dto) {
        this.db.save(dto);
    }

    public void delete(String userId) {
        this.db.remove((Bson)DBQuery.is((String)"user_id", (Object)userId));
    }
}

