/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.MongoCollection;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.bson.codecs.configuration.CodecRegistry;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.jackson.CustomJacksonCodecRegistry;

@Singleton
public class MongoCollections {
    private final ObjectMapper objectMapper;
    private final MongoConnection mongoConnection;

    @Inject
    public MongoCollections(MongoJackObjectMapperProvider objectMapperProvider, MongoConnection mongoConnection) {
        this.objectMapper = objectMapperProvider.get();
        this.mongoConnection = mongoConnection;
    }

    public <T> MongoCollection<T> get(String collectionName, Class<T> valueType) {
        MongoCollection collection = this.mongoConnection.getMongoDatabase().getCollection(collectionName, valueType);
        CustomJacksonCodecRegistry jacksonCodecRegistry = new CustomJacksonCodecRegistry(this.objectMapper, collection.getCodecRegistry());
        jacksonCodecRegistry.addCodecForClass(valueType);
        return collection.withCodecRegistry((CodecRegistry)jacksonCodecRegistry);
    }
}

