/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWriter;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.graylog2.database.jackson.CustomJacksonCodecRegistry;
import org.mongojack.JacksonCodecRegistry;
import org.mongojack.internal.stream.JacksonCodec;
import org.mongojack.internal.stream.JacksonDecoder;
import org.mongojack.internal.stream.JacksonEncoder;

public class CustomJacksonCodec<T>
extends JacksonCodec<T> {
    private final JacksonEncoder<T> encoder;
    private final JacksonDecoder<T> decoder;
    private final ObjectMapper objectMapper;
    private final CustomJacksonCodecRegistry jacksonCodecRegistry;

    public CustomJacksonCodec(JacksonEncoder<T> encoder, JacksonDecoder<T> decoder, ObjectMapper objectMapper, CustomJacksonCodecRegistry jacksonCodecRegistry) {
        super(encoder, decoder, objectMapper, (JacksonCodecRegistry)jacksonCodecRegistry);
        this.encoder = encoder;
        this.decoder = decoder;
        this.objectMapper = objectMapper;
        this.jacksonCodecRegistry = jacksonCodecRegistry;
    }

    public T generateIdIfAbsentFromDocument(T t) {
        if (this.documentHasId(t)) {
            return t;
        }
        try (BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());){
            Object object;
            this.encode((BsonWriter)writer, t, EncoderContext.builder().build());
            BsonDocument document = writer.getDocument();
            document.put("_id", (BsonValue)new BsonObjectId());
            try (BsonDocumentReader reader = new BsonDocumentReader(document);){
                object = this.decode((BsonReader)reader, DecoderContext.builder().build());
            }
            return (T)object;
        }
    }

    public Codec<T> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        return new CustomJacksonCodec<T>(this.encoder.withUuidRepresentation(uuidRepresentation), this.decoder.withUuidRepresentation(uuidRepresentation), this.objectMapper, this.jacksonCodecRegistry);
    }
}

