/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Locale;
import java.util.function.Function;
import org.apache.commons.lang3.EnumUtils;

public record ShardsInfo(String index, int shard, ShardType shardType, State state, long docs, String store, String ip, String node) {
    public static boolean isStartedPrimaryShard(ShardsInfo shardsInfo) {
        return shardsInfo.shardType() == ShardType.PRIMARY && shardsInfo.state() == State.STARTED;
    }

    public static ShardsInfo create(JsonNode jsonNode) {
        String index = jsonNode.get("index").asText();
        int shard = jsonNode.get("shard").asInt();
        String ip = ShardsInfo.getValueOrDefault(jsonNode, "ip", JsonNode::asText, null);
        String store = ShardsInfo.getValueOrDefault(jsonNode, "store", JsonNode::asText, null);
        String node = ShardsInfo.getValueOrDefault(jsonNode, "node", JsonNode::asText, null);
        long docs = ShardsInfo.getValueOrDefault(jsonNode, "docs", JsonNode::asLong, 0L);
        State state = (State)EnumUtils.getEnumIgnoreCase(State.class, (String)jsonNode.get("state").asText(), (Enum)State.UNKNOWN);
        ShardType shardType = ShardType.fromString(jsonNode.get("prirep").asText());
        return new ShardsInfo(index, shard, shardType, state, docs, store, ip, node);
    }

    private static <T> T getValueOrDefault(JsonNode jsonNode, String nodeName, Function<JsonNode, T> valueConverter, T defaultValue) {
        return jsonNode.hasNonNull(nodeName) ? valueConverter.apply(jsonNode) : defaultValue;
    }

    public static enum ShardType {
        PRIMARY,
        REPLICA,
        UNKNOWN;


        public static ShardType fromString(String value) {
            return switch (value.toLowerCase(Locale.ENGLISH)) {
                case "r" -> REPLICA;
                case "p" -> PRIMARY;
                default -> UNKNOWN;
            };
        }
    }

    public static enum State {
        INITIALIZING,
        RELOCATING,
        UNASSIGNED,
        STARTED,
        UNKNOWN;

    }
}

