/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.messages;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;
import org.graylog2.indexer.messages.AutoValue_IndexingResults;
import org.graylog2.indexer.messages.IndexingError;
import org.graylog2.indexer.messages.IndexingResult;
import org.graylog2.indexer.messages.IndexingSuccess;

@AutoValue
public abstract class IndexingResults {
    public abstract ImmutableList<IndexingSuccess> successes();

    public abstract ImmutableList<IndexingError> errors();

    public static IndexingResults create(List<IndexingSuccess> successful, List<IndexingError> errors) {
        return Builder.create().addSuccesses(successful).addErrors(errors).build();
    }

    public static IndexingResults empty() {
        return Builder.create().build();
    }

    public IndexingResults mergeWith(List<IndexingSuccess> successes, List<IndexingError> errors) {
        List<IndexingSuccess> mergedSuccesses = Stream.concat(this.successes().stream(), successes.stream()).distinct().toList();
        List<IndexingError> mergedErrors = Stream.concat(this.errors().stream(), errors.stream()).distinct().toList();
        return IndexingResults.create(mergedSuccesses, mergedErrors);
    }

    public List<? extends IndexingResult> allResults() {
        return Stream.concat(this.successes().stream(), this.errors().stream()).toList();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract ImmutableList.Builder<IndexingSuccess> successesBuilder();

        abstract ImmutableList.Builder<IndexingError> errorsBuilder();

        public static Builder create() {
            return new AutoValue_IndexingResults.Builder();
        }

        public final Builder addSuccesses(List<IndexingSuccess> successes) {
            this.successesBuilder().addAll(successes);
            return this;
        }

        public final Builder addErrors(List<IndexingError> errors) {
            this.errorsBuilder().addAll(errors);
            return this;
        }

        public final Builder addResults(IndexingResults results) {
            this.successesBuilder().addAll(results.successes());
            this.errorsBuilder().addAll(results.errors());
            return this;
        }

        public abstract IndexingResults build();
    }
}

