/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.database.PersistedService;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.shared.inputs.NoSuchInputTypeException;

public interface InputService
extends PersistedService {
    public List<Input> all();

    public List<Input> allOfThisNode(String var1);

    public Input create(String var1, Map<String, Object> var2);

    public Input create(Map<String, Object> var1);

    public <T extends Persisted> String saveWithoutEvents(T var1) throws ValidationException;

    public String update(Input var1) throws ValidationException;

    public Input find(String var1) throws NotFoundException;

    default public List<Input> allByType(String type) {
        return this.all().stream().filter(input -> Objects.equals(input.getType(), type)).toList();
    }

    public Set<Input> findByIds(Collection<String> var1);

    public Input findForThisNode(String var1, String var2) throws NotFoundException;

    public Input findForThisNodeOrGlobal(String var1, String var2) throws NotFoundException;

    public long totalCount();

    public long globalCount();

    public long localCount();

    public Map<String, Long> totalCountByType();

    public long localCountForNode(String var1);

    public long totalCountForNode(String var1);

    public long totalExtractorCount();

    public Map<Extractor.Type, Long> totalExtractorCountByType();

    public void addExtractor(Input var1, Extractor var2) throws ValidationException;

    public void addStaticField(Input var1, String var2, String var3) throws ValidationException;

    public List<Extractor> getExtractors(Input var1);

    public Extractor getExtractor(Input var1, String var2) throws NotFoundException;

    public void updateExtractor(Input var1, Extractor var2) throws ValidationException;

    public void removeExtractor(Input var1, String var2);

    public void removeStaticField(Input var1, String var2);

    public MessageInput getMessageInput(Input var1) throws NoSuchInputTypeException;

    public List<Map.Entry<String, String>> getStaticFields(Input var1);
}

