/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf.tcp;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import jakarta.inject.Inject;
import org.graylog2.inputs.codecs.GelfCodec;
import org.graylog2.inputs.transports.TcpTransport;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;

public class GELFTCPInput
extends MessageInput {
    private static final String NAME = "GELF TCP";

    @AssistedInject
    public GELFTCPInput(MetricRegistry metricRegistry, @Assisted Configuration configuration, TcpTransport.Factory tcpFactory, GelfCodec.Factory gelfCodecFactory, LocalMetricRegistry localRegistry, Config config, Descriptor descriptor, ServerStatus serverStatus) {
        super(metricRegistry, configuration, tcpFactory.create(GELFTCPInput.overrideDelimiter(configuration)), localRegistry, gelfCodecFactory.create(configuration), config, descriptor, serverStatus);
    }

    private static Configuration overrideDelimiter(Configuration configuration) {
        configuration.setBoolean("use_null_delimiter", true);
        return configuration;
    }

    public static class Config
    extends MessageInput.Config {
        @Inject
        public Config(TcpTransport.Factory transport, GelfCodec.Factory codec) {
            super(transport.getConfig(), codec.getConfig());
        }
    }

    public static class Descriptor
    extends MessageInput.Descriptor {
        @Inject
        public Descriptor() {
            super(GELFTCPInput.NAME, false, "");
        }
    }

    public static interface Factory
    extends MessageInput.Factory<GELFTCPInput> {
        @Override
        public GELFTCPInput create(Configuration var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

