/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.io.IOException;

public class SemverRequirementDeserializer
extends StdDeserializer<Requirement> {
    private final Semver.SemverType semverType;

    public SemverRequirementDeserializer() {
        this(Semver.SemverType.NPM);
    }

    public SemverRequirementDeserializer(Semver.SemverType semverType) {
        super(Requirement.class);
        this.semverType = semverType;
    }

    public Requirement deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.currentTokenId()) {
            case 6: {
                String str = p.getText().trim();
                try {
                    return this.buildRequirement(str);
                }
                catch (SemverException e) {
                    ctxt.reportInputMismatch((JsonDeserializer)this, e.getMessage(), new Object[0]);
                }
            }
        }
        throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.VALUE_STRING, null);
    }

    private Requirement buildRequirement(String s) {
        switch (this.semverType) {
            case STRICT: {
                return Requirement.buildStrict((String)s);
            }
            case LOOSE: {
                return Requirement.buildLoose((String)s);
            }
            case NPM: {
                return Requirement.buildNPM((String)s);
            }
            case COCOAPODS: {
                return Requirement.buildCocoapods((String)s);
            }
            case IVY: {
                return Requirement.buildIvy((String)s);
            }
        }
        return null;
    }
}

