/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters.dnslookup;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.graylog2.lookup.adapters.dnslookup.DnsNameResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsResolverPool {
    private static final Logger LOG = LoggerFactory.getLogger(DnsResolverPool.class);
    private final long poolSize;
    private final long poolRefreshSeconds;
    private final ScheduledExecutorService executorService;
    private final NioEventLoopGroup eventLoopGroup;
    private final DnsNameResolverFactory resolverFactory;
    private final List<ResolverLease> resolverPool;

    protected DnsResolverPool(String dnsServerIps, long queryTimeout, long poolSize, long poolRefreshSeconds) {
        this.poolSize = poolSize;
        this.poolRefreshSeconds = poolRefreshSeconds;
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("dns-lookup-refresh-task-%d").build());
        this.resolverPool = Collections.synchronizedList(new ArrayList());
        this.eventLoopGroup = new NioEventLoopGroup();
        this.resolverFactory = new DnsNameResolverFactory(this.eventLoopGroup, dnsServerIps, queryTimeout);
    }

    protected void initialize() {
        int i = 0;
        while ((long)i < this.poolSize) {
            this.resolverPool.add(new ResolverLease(this.resolverFactory.create()));
            ++i;
        }
        this.executorService.scheduleAtFixedRate(new ResolverRefreshTask(), this.poolRefreshSeconds, this.poolRefreshSeconds, TimeUnit.SECONDS);
    }

    protected ResolverLease takeLease() {
        if (this.resolverPool.size() == 0) {
            throw new RuntimeException("Resolver pool is empty. Cannot return lease.");
        }
        ResolverLease lease = this.resolverPool.get(this.randomResolverIndex());
        lease.take();
        return lease;
    }

    protected void returnLease(ResolverLease lease) {
        lease.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOG.debug("Attempting to stop pool.");
        this.executorService.shutdown();
        if (this.resolverPool == null) {
            LOG.error("Resolver pool has not been initialized.");
            return;
        }
        List<ResolverLease> list = this.resolverPool;
        synchronized (list) {
            Iterator<ResolverLease> iterator = this.resolverPool.iterator();
            while (iterator.hasNext()) {
                ResolverLease lease = iterator.next();
                LOG.debug("Attempting to stop resolver [{}].", (Object)lease.getId());
                if (lease.isLeased()) {
                    LOG.warn("Attempting to stop a leased resolver...");
                }
                lease.take();
                lease.getResolver().close();
                iterator.remove();
                LOG.debug("Successfully stopped resolver [{}].", (Object)lease.getId());
            }
        }
        Future shutdownFuture = this.eventLoopGroup.shutdownGracefully();
        shutdownFuture.addListener(future -> LOG.debug("Finished shutting down pool."));
        LOG.debug("Resolver pool shutdown complete.");
    }

    protected boolean isStopped() {
        return (this.eventLoopGroup == null || this.eventLoopGroup.isShutdown()) && this.executorService.isShutdown();
    }

    protected int randomResolverIndex() {
        return ThreadLocalRandom.current().nextInt(this.resolverPool.size());
    }

    protected int poolSize() {
        return this.resolverPool != null ? this.resolverPool.size() : 0;
    }

    protected static class ResolverLease {
        private final String id = UUID.randomUUID().toString();
        private final DnsNameResolver resolver;
        private AtomicInteger leaseCount;
        private AtomicBoolean hasBeenLeased;

        private ResolverLease(DnsNameResolver resolver) {
            this.resolver = resolver;
            this.leaseCount = new AtomicInteger(0);
            this.hasBeenLeased = new AtomicBoolean();
        }

        private void take() {
            this.leaseCount.incrementAndGet();
            this.hasBeenLeased.set(true);
        }

        private void release() {
            this.leaseCount.decrementAndGet();
        }

        protected String getId() {
            return this.id;
        }

        private boolean isLeased() {
            return this.leaseCount.get() > 0;
        }

        private boolean getHasBeenLeased() {
            return this.hasBeenLeased.get();
        }

        protected DnsNameResolver getResolver() {
            return this.resolver;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolverLease that = (ResolverLease)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private class ResolverRefreshTask
    implements Runnable {
        private ResolverRefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("Starting resolver refresh.");
            LOG.debug("Existing IDs: [{}]", (Object)DnsResolverPool.this.resolverPool.stream().map(ResolverLease::getId).collect(Collectors.joining(", ")));
            List<ResolverLease> list = DnsResolverPool.this.resolverPool;
            synchronized (list) {
                ListIterator<ResolverLease> iterator = DnsResolverPool.this.resolverPool.listIterator();
                while (iterator.hasNext()) {
                    ResolverLease lease = iterator.next();
                    if (!lease.getHasBeenLeased()) {
                        LOG.debug("Resolver [{}] has not been leased yet. Skipping refresh.", (Object)lease.getId());
                        continue;
                    }
                    if (!lease.isLeased()) {
                        lease.getResolver().close();
                        iterator.remove();
                        iterator.add(new ResolverLease(DnsResolverPool.this.resolverFactory.create()));
                        continue;
                    }
                    LOG.warn("Lease for resolver [{}] is in-use. Skipping refresh. This will be attempted again in [{}] seconds. If this happens frequently for high message rates, consider increasing the [dns_lookup_adapter_resolver_pool_size = {}] server configuration property to allow more DNS resolvers.", new Object[]{lease.getId(), DnsResolverPool.this.poolRefreshSeconds, DnsResolverPool.this.resolverPool.size()});
                }
            }
            LOG.debug("Resolver IDs refreshed: [{}]", (Object)DnsResolverPool.this.resolverPool.stream().map(ResolverLease::getId).collect(Collectors.joining(", ")));
            LOG.debug("Finished resolver refresh.");
        }
    }
}

