/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.migrations.AutoValue_V20161122174500_AssignIndexSetsToStreamsMigration_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20161122174500_AssignIndexSetsToStreamsMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20161122174500_AssignIndexSetsToStreamsMigration.class);
    private final StreamService streamService;
    private final IndexSetService indexSetService;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20161122174500_AssignIndexSetsToStreamsMigration(StreamService streamService, IndexSetService indexSetService, ClusterConfigService clusterConfigService) {
        this.streamService = streamService;
        this.indexSetService = indexSetService;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2016-11-22T17:45:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        IndexSetConfig indexSetConfig = this.findDefaultIndexSet();
        ImmutableSet.Builder completedStreamIds = ImmutableSet.builder();
        ImmutableSet.Builder failedStreamIds = ImmutableSet.builder();
        for (Stream stream : this.streamService.loadAll()) {
            if (!Strings.isNullOrEmpty((String)stream.getIndexSetId())) continue;
            LOG.info("Assigning index set <{}> ({}) to stream <{}> ({})", new Object[]{indexSetConfig.id(), indexSetConfig.title(), stream.getId(), stream.getTitle()});
            stream.setIndexSetId(indexSetConfig.id());
            try {
                this.streamService.save(stream);
                completedStreamIds.add((Object)stream.getId());
            }
            catch (ValidationException e) {
                LOG.error("Unable to save stream <{}>", (Object)stream.getId(), (Object)e);
                failedStreamIds.add((Object)stream.getId());
            }
        }
        this.clusterConfigService.write(MigrationCompleted.create(indexSetConfig.id(), (Set<String>)completedStreamIds.build(), (Set<String>)failedStreamIds.build()));
    }

    private IndexSetConfig findDefaultIndexSet() {
        List<IndexSetConfig> indexSetConfigs = this.indexSetService.findAll();
        Preconditions.checkState((indexSetConfigs.size() < 2 ? 1 : 0) != 0, (Object)"Found more than one index set config!");
        return (IndexSetConfig)indexSetConfigs.stream().findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find any index set config!"));
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="index_set_id")
        public abstract String indexSetId();

        @JsonProperty(value="completed_stream_ids")
        public abstract Set<String> completedStreamIds();

        @JsonProperty(value="failed_stream_ids")
        public abstract Set<String> failedStreamIds();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="index_set_id") String indexSetId, @JsonProperty(value="completed_stream_ids") Set<String> completedStreamIds, @JsonProperty(value="failed_stream_ids") Set<String> failedStreamIds) {
            return new AutoValue_V20161122174500_AssignIndexSetsToStreamsMigration_MigrationCompleted(indexSetId, completedStreamIds, failedStreamIds);
        }
    }
}

