/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.grok.GrokPatternsDeletedEvent;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2018070614390000_EnforceUniqueGrokPatterns
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V2018070614390000_EnforceUniqueGrokPatterns.class);
    private final MongoCollection<Document> collection;
    private final ClusterEventBus clusterEventBus;
    private boolean indexCreated = false;

    @Inject
    public V2018070614390000_EnforceUniqueGrokPatterns(MongoConnection mongoConnection, ClusterEventBus clusterEventBus) {
        this((MongoCollection<Document>)mongoConnection.getMongoDatabase().getCollection("grok_patterns"), clusterEventBus);
    }

    V2018070614390000_EnforceUniqueGrokPatterns(MongoCollection<Document> collection, ClusterEventBus clusterEventBus) {
        this.collection = collection;
        this.clusterEventBus = clusterEventBus;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2018-07-06T14:39:00Z");
    }

    @Override
    public void upgrade() {
        boolean indexExists = false;
        for (Document document : this.collection.listIndexes()) {
            if (!"idx_name_asc_unique".equals(document.getString((Object)"name")) || !document.getBoolean((Object)"unique").booleanValue()) continue;
            indexExists = true;
            break;
        }
        if (indexExists) {
            LOG.debug("Unique index for Grok patterns already exists, skipping migration.");
            return;
        }
        HashSet<String> grokPatterns = new HashSet<String>();
        HashMap<ObjectId, String> duplicatePatterns = new HashMap<ObjectId, String>();
        for (Document document : this.collection.find()) {
            ObjectId id = document.getObjectId((Object)"_id");
            String name = document.getString((Object)"name");
            String pattern = document.getString((Object)"pattern");
            if (grokPatterns.contains(name)) {
                LOG.info("Marking duplicate Grok pattern <{}> for removal: {}\t{}", new Object[]{id, name, pattern});
                duplicatePatterns.put(id, name);
                continue;
            }
            LOG.debug("Recording Grok pattern <{}>: {}\t{}", new Object[]{id, name, pattern});
            grokPatterns.add(name);
        }
        for (ObjectId id : duplicatePatterns.keySet()) {
            LOG.info("Deleting duplicate Grok pattern with ID <{}>", (Object)id);
            this.collection.deleteOne(Filters.eq((String)"_id", (Object)id));
        }
        IndexOptions indexOptions = new IndexOptions().name("idx_name_asc_unique").unique(true);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"name"}), indexOptions);
        if (!duplicatePatterns.isEmpty()) {
            this.clusterEventBus.post(GrokPatternsDeletedEvent.create((Set<String>)ImmutableSet.copyOf(duplicatePatterns.values())));
        }
        this.indexCreated = true;
    }

    @VisibleForTesting
    boolean isIndexCreated() {
        return this.indexCreated;
    }
}

