/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mongodb.DuplicateKeyException;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bson.types.ObjectId;
import org.graylog.events.notifications.EventNotificationSettings;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.storage.EventStorageHandler;
import org.graylog.events.processor.storage.PersistToStreamsStorageHandler;
import org.graylog.events.processor.systemnotification.SystemNotificationEventProcessorConfig;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetValidator;
import org.graylog2.indexer.MongoIndexSet;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetConfigFactory;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamImpl;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.DBQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20190705071400_AddEventIndexSetsMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20190705071400_AddEventIndexSetsMigration.class);
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final MongoIndexSet.Factory mongoIndexSetFactory;
    private final IndexSetService indexSetService;
    private final IndexSetValidator indexSetValidator;
    private final StreamService streamService;
    private final IndexSetConfigFactory indexSetConfigFactory;
    private final DBEventDefinitionService dbService;

    @Inject
    public V20190705071400_AddEventIndexSetsMigration(ElasticsearchConfiguration elasticsearchConfiguration, IndexSetConfigFactory indexSetConfigFactory, MongoIndexSet.Factory mongoIndexSetFactory, IndexSetService indexSetService, IndexSetValidator indexSetValidator, StreamService streamService, DBEventDefinitionService dbService) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.indexSetConfigFactory = indexSetConfigFactory;
        this.mongoIndexSetFactory = mongoIndexSetFactory;
        this.indexSetService = indexSetService;
        this.indexSetValidator = indexSetValidator;
        this.streamService = streamService;
        this.dbService = dbService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2019-07-05T07:14:00Z");
    }

    @Override
    public void upgrade() {
        this.ensureEventsStreamAndIndexSet("Graylog Events", "Stores Graylog events.", this.elasticsearchConfiguration.getDefaultEventsIndexPrefix(), "default_events_index_prefix", "000000000000000000000002", "All events", "Stream containing all events created by Graylog");
        this.ensureEventsStreamAndIndexSet("Graylog System Events", "Stores Graylog system events.", this.elasticsearchConfiguration.getDefaultSystemEventsIndexPrefix(), "default_system_events_index_prefix", "000000000000000000000003", "All system events", "Stream containing all system events created by Graylog");
        this.ensureSystemNotificationEventsDefinition();
    }

    private void ensureEventsStreamAndIndexSet(String indexSetTitle, String indexSetDescription, String indexPrefix, String indexPrefixConfigKey, String streamId, String streamTitle, String streamDescription) {
        this.checkIndexPrefixConflicts(indexPrefix, indexPrefixConfigKey);
        IndexSet eventsIndexSet = this.setupEventsIndexSet(indexSetTitle, indexSetDescription, indexPrefix);
        try {
            this.streamService.load(streamId);
        }
        catch (NotFoundException ignored) {
            this.createEventsStream(streamId, streamTitle, streamDescription, eventsIndexSet);
        }
    }

    private void checkIndexPrefixConflicts(String indexPrefix, String configKey) {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notEquals((String)"index_template_type", Optional.of("events")), DBQuery.is((String)"index_prefix", (Object)indexPrefix)});
        if (this.indexSetService.findOne(query).isPresent()) {
            String msg = String.format(Locale.US, "Index prefix conflict: a non-events index-set with prefix <%s> already exists. Configure a different <%s> value in the server config file.", indexPrefix, configKey);
            throw new IllegalStateException(msg);
        }
    }

    private Optional<IndexSetConfig> getEventsIndexSetConfig(String indexPrefix) {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"index_template_type", Optional.of("events")), DBQuery.is((String)"index_prefix", (Object)indexPrefix)});
        return this.indexSetService.findOne(query);
    }

    private IndexSet setupEventsIndexSet(String indexSetTitle, String indexSetDescription, String indexPrefix) {
        Optional<IndexSetConfig> optionalIndexSetConfig = this.getEventsIndexSetConfig(indexPrefix);
        if (optionalIndexSetConfig.isPresent()) {
            return this.mongoIndexSetFactory.create(optionalIndexSetConfig.get());
        }
        IndexSetConfig indexSetConfig = this.indexSetConfigFactory.createDefault().title(indexSetTitle).description(indexSetDescription).indexTemplateType("events").isWritable(true).isRegular(false).indexPrefix(indexPrefix).indexTemplateName(indexPrefix + "-template").build();
        try {
            Optional<IndexSetValidator.Violation> violation = this.indexSetValidator.validate(indexSetConfig);
            if (violation.isPresent()) {
                throw new RuntimeException(violation.get().message());
            }
            IndexSetConfig savedIndexSet = this.indexSetService.save(indexSetConfig);
            LOG.info("Successfully created events index-set <{}/{}>", (Object)savedIndexSet.id(), (Object)savedIndexSet.title());
            return this.mongoIndexSetFactory.create(savedIndexSet);
        }
        catch (DuplicateKeyException e) {
            LOG.error("Couldn't create index-set <{}/{}>", (Object)indexSetTitle, (Object)indexPrefix);
            throw new RuntimeException(e.getMessage());
        }
    }

    private void createEventsStream(String streamId, String streamTitle, String streamDescription, IndexSet indexSet) {
        ObjectId id = new ObjectId(streamId);
        ImmutableMap fields = ImmutableMap.builder().put((Object)"title", (Object)streamTitle).put((Object)"description", (Object)streamDescription).put((Object)"disabled", (Object)false).put((Object)"created_at", (Object)DateTime.now((DateTimeZone)DateTimeZone.UTC)).put((Object)"creator_user_id", (Object)"admin").put((Object)"matching_type", (Object)Stream.MatchingType.DEFAULT.name()).put((Object)"remove_matches_from_default_stream", (Object)true).put((Object)"index_set_id", (Object)Objects.requireNonNull(indexSet.getConfig().id(), "index set ID cannot be null")).put((Object)"is_default_stream", (Object)false).build();
        StreamImpl stream = new StreamImpl(id, (Map<String, Object>)fields, Collections.emptyList(), Collections.emptySet(), indexSet);
        try {
            this.streamService.save(stream);
            LOG.info("Successfully created events stream <{}/{}>", (Object)stream.getId(), (Object)stream.getTitle());
        }
        catch (ValidationException e) {
            LOG.error("Couldn't create events stream <{}/{}>! This is a bug!", new Object[]{streamId, streamTitle, e});
        }
    }

    private void ensureSystemNotificationEventsDefinition() {
        if (this.dbService.getSystemEventDefinitions().isEmpty()) {
            EventDefinitionDto eventDto = ((EventDefinitionDto.Builder)EventDefinitionDto.builder().title("System notification events").description("Reserved event definition for system notification events").alert(false).priority(1).keySpec((ImmutableList<String>)ImmutableList.of()).notificationSettings(EventNotificationSettings.builder().gracePeriodMs(0L).backlogSize(0L).build()).config(SystemNotificationEventProcessorConfig.builder().build()).storage((ImmutableList<EventStorageHandler.Config>)ImmutableList.of((Object)PersistToStreamsStorageHandler.Config.createWithSystemEventsStream())).scope("SYSTEM_NOTIFICATION_EVENT")).build();
            this.dbService.save(eventDto);
        }
    }
}

