/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.metrics.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThroughputCalculator
extends Periodical {
    private static final Logger log = LoggerFactory.getLogger(ThroughputCalculator.class);
    private final MetricRegistry metricRegistry;
    protected static final Pattern incomingMessagesPattern = Pattern.compile("org\\.graylog2\\.plugin\\.streams\\.Stream\\..*?\\.incomingMessages");
    protected static final MetricFilter streamMetricFilter = new MetricFilter(){

        public boolean matches(String name, Metric metric) {
            Matcher matcher = incomingMessagesPattern.matcher(name);
            return matcher.matches();
        }
    };
    private ConcurrentMap<String, CounterSample> sampledCounters = Maps.newConcurrentMap();

    @Inject
    public ThroughputCalculator(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean leaderOnly() {
        return false;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 1;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    public void doRun() {
        SortedMap counters = this.metricRegistry.getCounters(MetricUtils.filterSingleMetric("org.graylog2.throughput.output"));
        SortedMap inputCounters = this.metricRegistry.getCounters(MetricUtils.filterSingleMetric("org.graylog2.throughput.input"));
        SortedMap streamMeters = this.metricRegistry.getMeters(streamMetricFilter);
        Iterable entries = Iterables.concat(counters.entrySet(), inputCounters.entrySet(), streamMeters.entrySet());
        for (Map.Entry countingEntry : entries) {
            Counting value = (Counting)countingEntry.getValue();
            final String metricName = (String)countingEntry.getKey();
            CounterSample counterSample = (CounterSample)this.sampledCounters.get(metricName);
            if (counterSample == null) {
                counterSample = new CounterSample();
                this.sampledCounters.put(metricName, counterSample);
            }
            counterSample.updateAverage(value.getCount());
            String rateName = MetricRegistry.name((String)metricName, (String[])new String[]{"1-sec-rate"});
            if (this.metricRegistry.getMetrics().containsKey(rateName)) continue;
            try {
                log.debug("Registering derived, per-second metric {}", (Object)rateName);
                this.metricRegistry.register(rateName, (Metric)new Gauge<Double>(){

                    public Double getValue() {
                        CounterSample sample = (CounterSample)ThroughputCalculator.this.sampledCounters.get(metricName);
                        return sample == null ? 0.0 : sample.getCurrentAverage();
                    }
                });
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not register gauge {} despite checking before that it didn't exist. This should not happen.", (Object)rateName);
            }
        }
    }

    private static class CounterSample {
        private long previousCount = 0L;
        private double currentAverage = 0.0;

        private CounterSample() {
        }

        public void updateAverage(long currentCount) {
            this.currentAverage = currentCount - this.previousCount;
            this.previousCount = currentCount;
        }

        public double getCurrentAverage() {
            return this.currentAverage;
        }
    }
}

