/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.search;

import com.mongodb.client.model.Filters;
import java.util.regex.Pattern;
import org.bson.conversions.Bson;
import org.mongojack.DBQuery;

public abstract class SearchQueryOperator {
    public abstract DBQuery.Query buildQuery(String var1, Object var2);

    public abstract Bson buildBson(String var1, Object var2);

    public boolean equals(Object obj) {
        return obj.getClass().equals(this.getClass());
    }

    public static class LessEquals
    extends SearchQueryOperator {
        @Override
        public DBQuery.Query buildQuery(String key, Object value) {
            return DBQuery.lessThanEquals((String)key, (Object)value);
        }

        @Override
        public Bson buildBson(String key, Object value) {
            return Filters.lte((String)key, (Object)value);
        }
    }

    public static class Less
    extends SearchQueryOperator {
        @Override
        public DBQuery.Query buildQuery(String key, Object value) {
            return DBQuery.lessThan((String)key, (Object)value);
        }

        @Override
        public Bson buildBson(String key, Object value) {
            return Filters.lt((String)key, (Object)value);
        }
    }

    public static class GreaterEquals
    extends SearchQueryOperator {
        @Override
        public DBQuery.Query buildQuery(String key, Object value) {
            return DBQuery.greaterThanEquals((String)key, (Object)value);
        }

        @Override
        public Bson buildBson(String key, Object value) {
            return Filters.gte((String)key, (Object)value);
        }
    }

    public static class Greater
    extends SearchQueryOperator {
        @Override
        public DBQuery.Query buildQuery(String key, Object value) {
            return DBQuery.greaterThan((String)key, (Object)value);
        }

        @Override
        public Bson buildBson(String key, Object value) {
            return Filters.gt((String)key, (Object)value);
        }
    }

    public static class Regexp
    extends SearchQueryOperator {
        @Override
        public DBQuery.Query buildQuery(String key, Object value) {
            return DBQuery.regex((String)key, (Pattern)Pattern.compile(Pattern.quote(value.toString()), 2));
        }

        @Override
        public Bson buildBson(String key, Object value) {
            return Filters.regex((String)key, (Pattern)Pattern.compile(Pattern.quote(value.toString()), 2));
        }
    }

    public static class Equals
    extends SearchQueryOperator {
        @Override
        public DBQuery.Query buildQuery(String key, Object value) {
            return DBQuery.is((String)key, (Object)value);
        }

        @Override
        public Bson buildBson(String key, Object value) {
            return Filters.eq((String)key, (Object)value);
        }
    }
}

