/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.initializers;

import com.google.common.base.Stopwatch;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.Uninterruptibles;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.shared.inputs.InputLauncher;
import org.graylog2.shared.inputs.InputRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InputSetupService
extends AbstractExecutionThreadService {
    private static final Logger LOG = LoggerFactory.getLogger(InputSetupService.class);
    private final InputRegistry inputRegistry;
    private final EventBus eventBus;
    private final InputLauncher inputLauncher;
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private AtomicReference<Lifecycle> previousLifecycle = new AtomicReference<Lifecycle>(Lifecycle.UNINITIALIZED);

    @Inject
    public InputSetupService(InputRegistry inputRegistry, EventBus eventBus, InputLauncher inputLauncher) {
        this.inputRegistry = inputRegistry;
        this.eventBus = eventBus;
        this.inputLauncher = inputLauncher;
    }

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this);
    }

    @Subscribe
    public void lifecycleChanged(Lifecycle lifecycle) {
        LOG.debug("Lifecycle is now {}", (Object)lifecycle);
        if (lifecycle == Lifecycle.RUNNING && this.previousLifecycle.get() == Lifecycle.STARTING || this.previousLifecycle.get() == Lifecycle.UNINITIALIZED) {
            LOG.info("Triggering launching persisted inputs, node transitioned from {} to {}", (Object)this.previousLifecycle.get(), (Object)lifecycle);
            this.previousLifecycle.set(lifecycle);
            this.startLatch.countDown();
        }
        if (lifecycle == Lifecycle.FAILED) {
            this.startLatch.countDown();
        }
    }

    protected void run() throws Exception {
        LOG.debug("Delaying launching persisted inputs until the node is in RUNNING state.");
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.startLatch);
        if (this.previousLifecycle.get() == Lifecycle.RUNNING) {
            LOG.debug("Launching persisted inputs now.");
            this.inputLauncher.launchAllPersisted();
        } else {
            LOG.error("Not starting any inputs because lifecycle is: {}", (Object)this.previousLifecycle.get());
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.stopLatch);
    }

    protected void triggerShutdown() {
        this.stopLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() throws Exception {
        LOG.debug("Stopping InputSetupService");
        this.eventBus.unregister((Object)this);
        for (IOState<MessageInput> state : this.inputRegistry.getRunningInputs()) {
            MessageInput input = state.getStoppable();
            LOG.info("Attempting to close input {}.", (Object)input.toIdentifier());
            Stopwatch s = Stopwatch.createStarted();
            try {
                input.stop();
                LOG.info("Input {} closed. Took [{}ms]", (Object)input.toIdentifier(), (Object)s.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (Exception e) {
                LOG.error("Unable to stop input {}: {}", (Object)input.toIdentifier(), (Object)e.getMessage());
            }
            finally {
                s.stop();
            }
        }
        LOG.debug("Stopped InputSetupService");
    }
}

