/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.process;

import jakarta.inject.Singleton;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.graylog2.shared.SuppressForbidden;
import org.graylog2.shared.system.stats.process.ProcessProbe;
import org.graylog2.shared.system.stats.process.ProcessStats;

@Singleton
public class JmxProcessProbe
implements ProcessProbe {
    private static final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method openFileDescriptorCountMethod = JmxProcessProbe.findMethod("getOpenFileDescriptorCount", operatingSystemMXBean.getClass());
    private static final Method maxFileDescriptorCountMethod = JmxProcessProbe.findMethod("getMaxFileDescriptorCount", operatingSystemMXBean.getClass());
    private static final long pid = JmxProcessProbe.findPid();

    @SuppressForbidden(value="Reflection necessary")
    private static Method findMethod(String methodName, Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static long findPid() {
        try {
            String processId = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            return Long.parseLong(processId);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private static <T> T invokeMethod(Method method, Object object, T defaultValue) {
        try {
            return (T)method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static long getOpenFileDescriptorCount() {
        return JmxProcessProbe.invokeMethod(openFileDescriptorCountMethod, operatingSystemMXBean, -1L);
    }

    static long getMaxFileDescriptorCount() {
        return JmxProcessProbe.invokeMethod(maxFileDescriptorCountMethod, operatingSystemMXBean, -1L);
    }

    @Override
    public ProcessStats processStats() {
        return ProcessStats.create(pid, JmxProcessProbe.getOpenFileDescriptorCount(), JmxProcessProbe.getMaxFileDescriptorCount());
    }
}

