/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import com.mongodb.client.MongoCollection;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.bson.conversions.Bson;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.security.entities.EntityOwnershipService;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.pagination.MongoPaginationHelper;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.plugin.database.users.User;
import org.graylog2.search.SearchQuery;

public class DBNotificationService {
    private static final String NOTIFICATION_COLLECTION_NAME = "event_notifications";
    private final EntityOwnershipService entityOwnerShipService;
    private final MongoCollection<NotificationDto> collection;
    private final MongoUtils<NotificationDto> mongoUtils;
    private final MongoPaginationHelper<NotificationDto> paginationHelper;

    @Inject
    public DBNotificationService(MongoCollections mongoCollections, EntityOwnershipService entityOwnerShipService) {
        this.collection = mongoCollections.collection(NOTIFICATION_COLLECTION_NAME, NotificationDto.class);
        this.mongoUtils = mongoCollections.utils(this.collection);
        this.paginationHelper = mongoCollections.paginationHelper(this.collection);
        this.entityOwnerShipService = entityOwnerShipService;
    }

    public PaginatedList<NotificationDto> searchPaginated(SearchQuery query, Predicate<NotificationDto> filter, Bson sort, int page, int perPage) {
        return this.paginationHelper.filter(query.toBson()).sort(sort).perPage(perPage).page(page, filter);
    }

    public NotificationDto saveWithOwnership(NotificationDto notificationDto, User user) {
        NotificationDto dto = this.save(notificationDto);
        this.entityOwnerShipService.registerNewEventNotification(dto.id(), user);
        return dto;
    }

    public NotificationDto save(NotificationDto notificationDto) {
        if (notificationDto.id() != null) {
            this.collection.replaceOne(MongoUtils.idEq(notificationDto.id()), (Object)notificationDto);
            return notificationDto;
        }
        String id = MongoUtils.insertedIdAsString(this.collection.insertOne((Object)notificationDto));
        return notificationDto.toBuilder().id(id).build();
    }

    public int delete(String id) {
        this.entityOwnerShipService.unregisterEventNotification(id);
        return (int)this.collection.deleteOne(MongoUtils.idEq(id)).getDeletedCount();
    }

    public Optional<NotificationDto> get(String id) {
        return this.mongoUtils.getById(id);
    }

    public Stream<NotificationDto> streamAll() {
        return MongoUtils.stream(this.collection.find());
    }
}

