/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.graylog.events.configuration.EventsConfigurationProvider;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationModelData;
import org.graylog.events.notifications.EventNotificationService;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.events.notifications.types.HTTPEventNotificationConfig;
import org.graylog.events.notifications.types.HTTPNotification;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.security.encryption.EncryptedValueService;
import org.graylog2.shared.bindings.providers.ParameterizedHttpClientProvider;
import org.graylog2.system.urlwhitelist.UrlWhitelistNotificationService;
import org.graylog2.system.urlwhitelist.UrlWhitelistService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPEventNotification
extends HTTPNotification
implements EventNotification {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPEventNotification.class);
    private static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/json");
    private final EventNotificationService notificationCallbackService;
    private final ObjectMapper objectMapper;
    private final EventsConfigurationProvider configurationProvider;
    private final ParameterizedHttpClientProvider parameterizedHttpClientProvider;

    @Inject
    public HTTPEventNotification(EventNotificationService notificationCallbackService, ObjectMapper objectMapper, UrlWhitelistService whitelistService, UrlWhitelistNotificationService urlWhitelistNotificationService, EncryptedValueService encryptedValueService, EventsConfigurationProvider configurationProvider, ParameterizedHttpClientProvider parameterizedHttpClientProvider) {
        super(whitelistService, urlWhitelistNotificationService, encryptedValueService);
        this.notificationCallbackService = notificationCallbackService;
        this.objectMapper = objectMapper;
        this.configurationProvider = configurationProvider;
        this.parameterizedHttpClientProvider = parameterizedHttpClientProvider;
    }

    private OkHttpClient selectClient(HTTPEventNotificationConfig notificationConfig) {
        boolean withKeepAlive = this.configurationProvider.get().notificationsKeepAliveProbe();
        return this.parameterizedHttpClientProvider.get(withKeepAlive, notificationConfig.skipTLSVerification());
    }

    @Override
    public void execute(EventNotificationContext ctx) throws TemporaryEventNotificationException, PermanentEventNotificationException {
        byte[] body;
        HTTPEventNotificationConfig config = (HTTPEventNotificationConfig)ctx.notificationConfig();
        ImmutableList<MessageSummary> backlog = this.notificationCallbackService.getBacklogForEvent(ctx);
        EventNotificationModelData model = EventNotificationModelData.of(ctx, backlog);
        HttpUrl httpUrl = this.validateUrl(config.url(), ctx.notificationId(), model.eventDefinitionTitle());
        Request.Builder builder = new Request.Builder();
        this.addAuthHeader(builder, config.basicAuth());
        this.addApiKey(builder, httpUrl, config.apiKey(), config.apiSecret(), config.apiKeyAsHeader());
        try {
            body = this.objectMapper.writeValueAsBytes((Object)model);
        }
        catch (JsonProcessingException e) {
            throw new PermanentEventNotificationException("Unable to serialize notification", e);
        }
        Request request = builder.post(RequestBody.create((byte[])body, (MediaType)CONTENT_TYPE)).build();
        LOG.debug("Requesting HTTP endpoint at <{}> in notification <{}>", (Object)config.url(), (Object)ctx.notificationId());
        OkHttpClient httpClient = this.selectClient(config);
        try (Response r = httpClient.newCall(request).execute();){
            if (!r.isSuccessful()) {
                throw new PermanentEventNotificationException("Expected successful HTTP response [2xx] but got [" + r.code() + "]. " + config.url());
            }
        }
        catch (IOException e) {
            throw new PermanentEventNotificationException(e.getMessage());
        }
    }

    public static interface Factory
    extends EventNotification.Factory<HTTPEventNotification> {
        @Override
        public HTTPEventNotification create();
    }
}

