/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.conversions.Bson;
import org.graylog.events.processor.DBEventProcessorStateService;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.SearchFilterableConfig;
import org.graylog.plugins.views.search.searchfilters.db.SearchFiltersReFetcher;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.security.entities.EntityOwnershipService;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.pagination.MongoPaginationHelper;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.database.utils.ScopedEntityMongoUtils;
import org.graylog2.plugin.database.users.User;
import org.graylog2.search.SearchQuery;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBEventDefinitionService {
    private static final Logger LOG = LoggerFactory.getLogger(DBEventDefinitionService.class);
    public static final String COLLECTION_NAME = "event_definitions";
    private final MongoCollection<EventDefinitionDto> collection;
    private final MongoUtils<EventDefinitionDto> mongoUtils;
    private final ScopedEntityMongoUtils<EventDefinitionDto> scopedEntityMongoUtils;
    private final MongoPaginationHelper<EventDefinitionDto> paginationHelper;
    private final DBEventProcessorStateService stateService;
    private final EntityOwnershipService entityOwnerShipService;
    private final SearchFiltersReFetcher searchFiltersRefetcher;

    @Inject
    public DBEventDefinitionService(MongoCollections mongoCollections, DBEventProcessorStateService stateService, EntityOwnershipService entityOwnerShipService, EntityScopeService entityScopeService, SearchFiltersReFetcher searchFiltersRefetcher) {
        this.collection = mongoCollections.collection(COLLECTION_NAME, EventDefinitionDto.class);
        this.mongoUtils = mongoCollections.utils(this.collection);
        this.scopedEntityMongoUtils = mongoCollections.scopedEntityUtils(this.collection, entityScopeService);
        this.paginationHelper = mongoCollections.paginationHelper(this.collection);
        this.stateService = stateService;
        this.entityOwnerShipService = entityOwnerShipService;
        this.searchFiltersRefetcher = searchFiltersRefetcher;
    }

    public PaginatedList<EventDefinitionDto> searchPaginated(SearchQuery query, Predicate<EventDefinitionDto> filter, Bson sort, int page, int perPage) {
        Bson dbQuery = query.toBson();
        PaginatedList<EventDefinitionDto> list = filter == null ? this.paginationHelper.filter(dbQuery).sort(sort).perPage(perPage).page(page) : this.paginationHelper.filter(dbQuery).sort(sort).perPage(perPage).page(page, filter);
        return new PaginatedList<EventDefinitionDto>(list.stream().map(this::getEventDefinitionWithRefetchedFilters).collect(Collectors.toList()), list.pagination().total(), page, perPage);
    }

    public EventDefinitionDto saveWithOwnership(EventDefinitionDto eventDefinitionDto, User user) {
        EventDefinitionDto dto = this.save(eventDefinitionDto);
        this.entityOwnerShipService.registerNewEventDefinition(dto.id(), user);
        return dto;
    }

    public EventDefinitionDto save(EventDefinitionDto entity) {
        EventDefinitionDto enrichedWithUpdateDate = entity.toBuilder().updatedAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).build();
        if (enrichedWithUpdateDate.id() == null) {
            String id = this.scopedEntityMongoUtils.create(enrichedWithUpdateDate);
            enrichedWithUpdateDate = enrichedWithUpdateDate.toBuilder().id(id).build();
        } else {
            this.scopedEntityMongoUtils.update(enrichedWithUpdateDate);
        }
        return this.getEventDefinitionWithRefetchedFilters(enrichedWithUpdateDate);
    }

    public Optional<EventDefinitionDto> get(String id) {
        return this.mongoUtils.getById(id).map(this::getEventDefinitionWithRefetchedFilters);
    }

    private EventDefinitionDto getEventDefinitionWithRefetchedFilters(EventDefinitionDto eventDefinition) {
        EventProcessorConfig config = eventDefinition.config();
        if (this.searchFiltersRefetcher.turnedOn() && config instanceof SearchFilterableConfig) {
            List<UsedSearchFilter> filters = ((SearchFilterableConfig)((Object)config)).filters();
            EventProcessorConfig updatedConfig = config.updateFilters(this.searchFiltersRefetcher.reFetch(filters));
            if (updatedConfig == null) {
                return eventDefinition;
            }
            return eventDefinition.toBuilder().config(updatedConfig).build();
        }
        return eventDefinition;
    }

    public void updateMatchedAt(String id, DateTime timeStamp) {
        this.collection.findOneAndUpdate(MongoUtils.idEq(id), Updates.set((String)"matched_at", (Object)timeStamp));
    }

    public void updateState(String id, EventDefinition.State state) {
        this.collection.findOneAndUpdate(MongoUtils.idEq(id), Updates.set((String)"state", (Object)((Object)state)));
    }

    public int delete(String id) {
        return this.scopedEntityMongoUtils.deleteById(id) ? 1 : 0;
    }

    public void forceDelete(String id) {
        this.scopedEntityMongoUtils.forceDelete(id);
    }

    public long deleteUnregister(String id) {
        EventDefinitionDto dto = this.get(id).orElseThrow(() -> new IllegalArgumentException("Event Definition not found."));
        this.scopedEntityMongoUtils.ensureDeletability(dto);
        this.scopedEntityMongoUtils.ensureMutability(dto);
        return this.doDeleteUnregister(id, () -> this.scopedEntityMongoUtils.forceDelete(id));
    }

    public long deleteUnregisterImmutable(String id) {
        return this.doDeleteUnregister(id, () -> this.scopedEntityMongoUtils.forceDelete(id));
    }

    private long doDeleteUnregister(String id, Supplier<Long> deleteSupplier) {
        try {
            this.stateService.deleteByEventDefinitionId(id);
        }
        catch (Exception e) {
            LOG.error("Couldn't delete event processor state for <{}>", (Object)id, (Object)e);
        }
        this.entityOwnerShipService.unregisterEventDefinition(id);
        return deleteSupplier.get();
    }

    public List<EventDefinitionDto> getByNotificationId(String notificationId) {
        String field = String.format(Locale.US, "%s.%s", "notifications", "notification_id");
        return MongoUtils.stream(this.collection.find(Filters.eq((String)field, (Object)notificationId))).toList();
    }

    public List<EventDefinitionDto> getSystemEventDefinitions() {
        return MongoUtils.stream(this.collection.find(Filters.eq((String)"_scope", (Object)"SYSTEM_NOTIFICATION_EVENT"))).toList();
    }

    @NotNull
    public List<EventDefinitionDto> getByArrayValue(String arrayField, String field, String value) {
        return MongoUtils.stream(this.collection.find(Filters.elemMatch((String)arrayField, (Bson)Filters.eq((String)field, (Object)value)))).toList();
    }

    public boolean isMutable(EventDefinitionDto eventDefinition) {
        return this.scopedEntityMongoUtils.isMutable(eventDefinition);
    }

    public Stream<EventDefinitionDto> streamAll() {
        return MongoUtils.stream(this.collection.find());
    }
}

