/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.rest;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotBlank;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.events.notifications.DBNotificationService;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.events.notifications.NotificationResourceHandler;
import org.graylog.events.notifications.types.EmailEventNotificationConfig;
import org.graylog.grn.GRNTypes;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityService;
import org.graylog.security.UserContext;
import org.graylog2.alarmcallbacks.EmailAlarmCallback;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.configuration.EmailConfiguration;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.rest.models.SortOrder;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;
import org.graylog2.rest.resources.entities.Sorting;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Events/Notifications", description="Manage event notifications", tags={"cloud"})
@Path(value="/events/notifications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class EventNotificationsResource
extends RestResource
implements PluginRestResource {
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).build();
    private static final String DEFAULT_SORT_FIELD = "title";
    private static final String DEFAULT_SORT_DIRECTION = "asc";
    private static final List<EntityAttribute> attributes = List.of(EntityAttribute.builder().id("title").title("Title").build(), EntityAttribute.builder().id("description").title("Description").build(), EntityAttribute.builder().id("type").title("Type").build());
    private static final EntityDefaults settings = EntityDefaults.builder().sort(Sorting.create("title", Sorting.Direction.valueOf("asc".toUpperCase(Locale.ROOT)))).build();
    private final DBNotificationService dbNotificationService;
    private final Set<AlarmCallback> availableLegacyAlarmCallbacks;
    private final SearchQueryParser searchQueryParser;
    private final NotificationResourceHandler resourceHandler;
    private final EmailConfiguration emailConfiguration;
    private final RecentActivityService recentActivityService;

    @Inject
    public EventNotificationsResource(DBNotificationService dbNotificationService, Set<AlarmCallback> availableLegacyAlarmCallbacks, NotificationResourceHandler resourceHandler, EmailConfiguration emailConfiguration, RecentActivityService recentActivityService) {
        this.dbNotificationService = dbNotificationService;
        this.availableLegacyAlarmCallbacks = availableLegacyAlarmCallbacks;
        this.resourceHandler = resourceHandler;
        this.searchQueryParser = new SearchQueryParser(DEFAULT_SORT_FIELD, (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
        this.emailConfiguration = emailConfiguration;
        this.recentActivityService = recentActivityService;
    }

    @GET
    @Timed
    @Path(value="/paginated")
    @ApiOperation(value="Get a paginated list of event notifications")
    @Produces(value={"application/json"})
    public PageListResponse<NotificationDto> getPage(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description,type") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") SortOrder order) {
        SearchQuery searchQuery = this.searchQueryParser.parse(query);
        if ("type".equals(sort)) {
            sort = "config.type";
        }
        PaginatedList<NotificationDto> result = this.dbNotificationService.searchPaginated(searchQuery, notification -> this.isPermitted("eventnotifications:read", notification.id()), order.toBsonSort(sort), page, perPage);
        return PageListResponse.create(query, result.pagination(), (long)result.grandTotal().orElse(0L), sort, order, result.delegate(), attributes, settings);
    }

    @GET
    @ApiOperation(value="List all available notifications")
    @Deprecated
    public PaginatedResponse<NotificationDto> listNotifications(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query) {
        SearchQuery searchQuery = this.searchQueryParser.parse(query);
        PaginatedList<NotificationDto> result = this.dbNotificationService.searchPaginated(searchQuery, notification -> this.isPermitted("eventnotifications:read", notification.id()), SortOrder.ASCENDING.toBsonSort(DEFAULT_SORT_FIELD), page, perPage);
        return PaginatedResponse.create("notifications", result, query);
    }

    @GET
    @Path(value="/{notificationId}")
    @ApiOperation(value="Get a notification")
    public NotificationDto get(@ApiParam(name="notificationId") @PathParam(value="notificationId") @NotBlank String notificationId) {
        this.checkPermission("eventnotifications:read", notificationId);
        return this.dbNotificationService.get(notificationId).orElseThrow(() -> new NotFoundException("Notification " + notificationId + " doesn't exist"));
    }

    @POST
    @ApiOperation(value="Create new notification definition")
    @AuditEvent(type="events:notification:create")
    @RequiresPermissions(value={"eventnotifications:create"})
    public Response create(@ApiParam(name="JSON Body") NotificationDto dto, @Context UserContext userContext) {
        ValidationResult validationResult = dto.validate();
        this.validateEmailConfiguration(dto, validationResult);
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        NotificationDto entity = this.resourceHandler.create(dto, Optional.ofNullable(userContext.getUser()));
        this.recentActivityService.create(entity.id(), GRNTypes.EVENT_NOTIFICATION, userContext.getUser());
        return Response.ok().entity((Object)entity).build();
    }

    @PUT
    @Path(value="/{notificationId}")
    @ApiOperation(value="Update existing notification")
    @AuditEvent(type="events:notification:update")
    public Response update(@ApiParam(name="notificationId") @PathParam(value="notificationId") @NotBlank String notificationId, @ApiParam(name="JSON Body") NotificationDto dto, @Context UserContext userContext) {
        this.checkPermission("eventnotifications:edit", notificationId);
        if (this.dbNotificationService.get(notificationId).isEmpty()) {
            throw new NotFoundException("Notification " + notificationId + " doesn't exist");
        }
        if (!notificationId.equals(dto.id())) {
            throw new BadRequestException("Notification IDs don't match");
        }
        ValidationResult validationResult = dto.validate();
        this.validateEmailConfiguration(dto, validationResult);
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        this.recentActivityService.update(notificationId, GRNTypes.EVENT_NOTIFICATION, userContext.getUser());
        return Response.ok().entity((Object)this.resourceHandler.update(dto)).build();
    }

    private void validateEmailConfiguration(NotificationDto dto, ValidationResult validationResult) {
        if (dto.config() instanceof EmailEventNotificationConfig) {
            EmailEventNotificationConfig emailEventNotificationConfig = (EmailEventNotificationConfig)dto.config();
            if (!this.emailConfiguration.isEnabled()) {
                validationResult.addError("config", "Email transport is not configured in graylog.conf");
            }
            if (Strings.isNullOrEmpty((String)this.emailConfiguration.getFromEmail()) && Strings.isNullOrEmpty((String)emailEventNotificationConfig.sender())) {
                validationResult.addError("sender", "No default sender specified in graylog.conf. You must specify one here.");
            } else {
                InternetAddress email;
                if (!Strings.isNullOrEmpty((String)emailEventNotificationConfig.sender())) {
                    try {
                        email = new InternetAddress(emailEventNotificationConfig.sender());
                        email.validate();
                    }
                    catch (AddressException e) {
                        validationResult.addError("sender", "Invalid email address.");
                    }
                }
                if (!Strings.isNullOrEmpty((String)this.emailConfiguration.getFromEmail())) {
                    try {
                        email = new InternetAddress(this.emailConfiguration.getFromEmail());
                        email.validate();
                    }
                    catch (AddressException e) {
                        validationResult.addError("sender", "Invalid default sender email address specified in graylog.conf.");
                    }
                }
            }
        }
    }

    @DELETE
    @Path(value="/{notificationId}")
    @ApiOperation(value="Delete a notification")
    @AuditEvent(type="events:notification:delete")
    public void delete(@ApiParam(name="notificationId") @PathParam(value="notificationId") @NotBlank String notificationId, @Context UserContext userContext) {
        this.checkPermission("eventnotifications:delete", notificationId);
        this.dbNotificationService.get(notificationId).ifPresent(n -> this.recentActivityService.delete(notificationId, GRNTypes.EVENT_NOTIFICATION, n.title(), userContext.getUser()));
        this.resourceHandler.delete(notificationId);
    }

    @POST
    @Timed
    @Path(value="/{notificationId}/test")
    @ApiOperation(value="Send a test alert for a given event notification")
    @ApiResponses(value={@ApiResponse(code=404, message="Event notification not found."), @ApiResponse(code=500, message="Error while testing event notification")})
    @NoAuditEvent(value="only used to test event notifications")
    public Response test(@ApiParam(name="notificationId", value="The event notification id to send a test alert for.", required=true) @PathParam(value="notificationId") @NotBlank String notificationId) {
        this.checkPermission("eventnotifications:edit", notificationId);
        NotificationDto notificationDto = this.dbNotificationService.get(notificationId).orElseThrow(() -> new NotFoundException("Notification " + notificationId + " doesn't exist"));
        this.resourceHandler.test(notificationDto, this.getSubject().getPrincipal().toString());
        return Response.ok().build();
    }

    @POST
    @Timed
    @Path(value="/test")
    @RequiresPermissions(value={"eventnotifications:create"})
    @ApiOperation(value="Send a test alert for a given event notification")
    @ApiResponses(value={@ApiResponse(code=400, message="Event notification is invalid."), @ApiResponse(code=500, message="Error while testing event notification")})
    @NoAuditEvent(value="only used to test event notifications")
    public Response test(@ApiParam(name="JSON Body") NotificationDto dto) {
        this.checkPermission("eventnotifications:create");
        ValidationResult validationResult = dto.validate();
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        this.resourceHandler.test(dto, this.getSubject().getPrincipal().toString());
        return Response.ok().build();
    }

    @GET
    @Path(value="/legacy/types")
    @ApiOperation(value="List all available legacy alarm callback types")
    public Response legacyTypes() {
        ImmutableMap.Builder typesBuilder = ImmutableMap.builder();
        for (AlarmCallback availableAlarmCallback : this.availableLegacyAlarmCallbacks) {
            typesBuilder.put((Object)availableAlarmCallback.getClass().getCanonicalName(), (Object)ImmutableMap.of((Object)"name", (Object)availableAlarmCallback.getName(), (Object)"configuration", this.getConfigurationRequest(availableAlarmCallback).asList()));
        }
        return Response.ok((Object)ImmutableMap.of((Object)"types", (Object)typesBuilder.build())).build();
    }

    private ConfigurationRequest getConfigurationRequest(AlarmCallback callback) {
        if (callback instanceof EmailAlarmCallback && this.isPermitted("users:list")) {
            return ((EmailAlarmCallback)callback).getEnrichedRequestedConfiguration();
        }
        return callback.getRequestedConfiguration();
    }
}

