/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.inputs.paloalto11;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.integrations.inputs.paloalto.PaloAltoMessageBase;
import org.graylog.integrations.inputs.paloalto.PaloAltoParser;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaloAlto11xCodec
implements Codec {
    private static final Logger LOG = LoggerFactory.getLogger(PaloAlto11xCodec.class);
    static final String CK_STORE_FULL_MESSAGE = "store_full_message";
    static final String CK_TIMEZONE = "timezone";
    public static final String NAME = "PaloAlto11x";
    public static final String EVENT_SOURCE_PRODUCT_NAME = "PAN";
    public static final String UNKNOWN = "unknown";
    private final Configuration configuration;
    private final MessageFactory messageFactory;
    private final PaloAltoParser rawMessageParser;
    private final DateTimeZone timezone;

    @AssistedInject
    public PaloAlto11xCodec(@Assisted Configuration configuration, PaloAltoParser rawMessageParser, MessageFactory messageFactory) {
        this.configuration = configuration;
        this.messageFactory = messageFactory;
        String timezoneID = configuration.getString(CK_TIMEZONE);
        this.timezone = timezoneID != null ? DateTimeZone.forID((String)timezoneID) : DateTimeZone.UTC;
        LOG.trace("Configured with time zone: {}", (Object)this.timezone);
        this.rawMessageParser = rawMessageParser;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        String rawMessageString = new String(rawMessage.getPayload(), StandardCharsets.UTF_8);
        LOG.trace("Received raw message: {}", (Object)rawMessageString);
        PaloAltoMessageBase p = null;
        try {
            p = this.rawMessageParser.parse(rawMessageString, this.timezone);
        }
        catch (Exception e) {
            LOG.warn("Cannot parse malformed Palo Alto 11x Message. Leaving message unparsed: {}", (Object)rawMessageString);
        }
        String payload = rawMessageString;
        String source = this.getRawMessageSource(rawMessage);
        DateTime timestamp = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        String panType = UNKNOWN;
        if (p != null) {
            if (p.payload() != null) {
                payload = p.payload();
            }
            if (p.source() != null) {
                source = p.source();
            }
            if (p.timestamp() != null) {
                timestamp = p.timestamp();
            }
            if (p.panType() != null) {
                panType = p.panType();
            }
        }
        Message message = this.messageFactory.createMessage(payload, source, timestamp);
        message.addField("event_source_product", EVENT_SOURCE_PRODUCT_NAME);
        message.addField("vendor_subtype", panType);
        if (this.configuration.getBoolean(CK_STORE_FULL_MESSAGE)) {
            message.addField("full_message", new String(rawMessage.getPayload(), StandardCharsets.UTF_8));
        }
        LOG.trace("Successfully processed [{}] message with [{}] fields.", (Object)panType, (Object)message.getFieldCount());
        return message;
    }

    private String getRawMessageSource(RawMessage rawMessage) {
        ResolvableInetSocketAddress address = rawMessage.getRemoteAddress();
        InetSocketAddress remoteAddress = address == null ? null : address.getInetSocketAddress();
        return remoteAddress == null ? UNKNOWN : remoteAddress.getAddress().toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }

    @ConfigClass
    public static class Config
    implements Codec.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = new ConfigurationRequest();
            r.addField(new DropdownField(PaloAlto11xCodec.CK_TIMEZONE, "Time Zone", DateTimeZone.UTC.getID(), DropdownField.ValueTemplates.timeZones(), "Time zone of the Palo Alto device", ConfigurationField.Optional.OPTIONAL));
            r.addField(new BooleanField(PaloAlto11xCodec.CK_STORE_FULL_MESSAGE, "Store full message?", false, "Store the full original Palo Alto message as full_message?"));
            return r;
        }

        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<PaloAlto11xCodec> {
        @Override
        public PaloAlto11xCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

