/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.formatting.units.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.graylog.plugins.formatting.units.model.SupportedUnits;

@Singleton
public class SupportedUnitsProvider
implements Provider<SupportedUnits> {
    private static final String SUPPORTED_UNITS_RES_FILE_LOCATION = "units/supported_units.json";
    private SupportedUnits supportedUnitsMemoized;
    private final ObjectMapper objectMapper;

    @Inject
    public SupportedUnitsProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public SupportedUnits get() {
        if (this.supportedUnitsMemoized == null) {
            try {
                this.supportedUnitsMemoized = this.loadFromFile(this.objectMapper);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Graylog cannot start because the file with a list of supported units is missing or corrupted : " + ex.getMessage());
            }
        }
        return this.supportedUnitsMemoized;
    }

    private SupportedUnits loadFromFile(ObjectMapper objectMapper) throws IOException {
        return (SupportedUnits)objectMapper.readValue(Resources.getResource((String)SUPPORTED_UNITS_RES_FILE_LOCATION), SupportedUnits.class);
    }
}

