/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.inject.assistedinject.Assisted;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.processors.ConfigurationStateUpdater;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.processors.listeners.NoopInterpreterListener;
import org.graylog2.database.MongoEntity;
import org.graylog2.decorators.Decorator;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;

public class PipelineProcessorMessageDecorator
implements SearchResponseDecorator {
    private static final String CONFIG_FIELD_PIPELINE = "pipeline";
    private final PipelineInterpreter pipelineInterpreter;
    private final ConfigurationStateUpdater pipelineStateUpdater;
    private final MessageFactory messageFactory;
    private final ImmutableSet<String> pipelines;

    @Inject
    public PipelineProcessorMessageDecorator(PipelineInterpreter pipelineInterpreter, ConfigurationStateUpdater pipelineStateUpdater, MessageFactory messageFactory, @Assisted Decorator decorator) {
        this.pipelineInterpreter = pipelineInterpreter;
        this.pipelineStateUpdater = pipelineStateUpdater;
        this.messageFactory = messageFactory;
        String pipelineId = (String)decorator.config().get(CONFIG_FIELD_PIPELINE);
        this.pipelines = Strings.isNullOrEmpty((String)pipelineId) ? ImmutableSet.of() : ImmutableSet.of((Object)pipelineId);
    }

    @Override
    @WithSpan
    public SearchResponse apply(SearchResponse searchResponse) {
        ArrayList<ResultMessageSummary> results = new ArrayList<ResultMessageSummary>();
        if (this.pipelines.isEmpty()) {
            return searchResponse;
        }
        searchResponse.messages().forEach(inMessage -> {
            Message message = this.messageFactory.createMessage(inMessage.message());
            List<Message> additionalCreatedMessages = this.pipelineInterpreter.processForPipelines(message, (Set<String>)this.pipelines, new NoopInterpreterListener(), this.pipelineStateUpdater.getLatestState());
            results.add(ResultMessageSummary.create(inMessage.highlightRanges(), message.getFields(), inMessage.index()));
            additionalCreatedMessages.forEach(additionalMessage -> results.add(ResultMessageSummary.create((Multimap<String, Range<Integer>>)ImmutableMultimap.of(), additionalMessage.getFields(), "[created from decorator]")));
        });
        return searchResponse.toBuilder().messages(results).build();
    }

    public static class Descriptor
    extends SearchResponseDecorator.Descriptor {
        public Descriptor() {
            super("Pipeline Processor Decorator", "https://docs.graylog.org/docs/processing-pipelines", "Pipeline Processor Decorator");
        }
    }

    public static class Config
    implements SearchResponseDecorator.Config {
        private final PipelineService pipelineService;

        @Inject
        public Config(PipelineService pipelineService) {
            this.pipelineService = pipelineService;
        }

        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            final Map<String, String> pipelineOptions = this.pipelineService.loadAll().stream().sorted((o1, o2) -> o1.title().compareTo(o2.title())).collect(Collectors.toMap(MongoEntity::id, PipelineDao::title));
            return new ConfigurationRequest(){
                {
                    this.addField(new DropdownField(PipelineProcessorMessageDecorator.CONFIG_FIELD_PIPELINE, "Pipeline", "", pipelineOptions, "Which pipeline to use for message decoration", ConfigurationField.Optional.NOT_OPTIONAL));
                }
            };
        }
    }

    public static interface Factory
    extends SearchResponseDecorator.Factory {
        @Override
        public PipelineProcessorMessageDecorator create(Decorator var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

