/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast;

import com.codahale.metrics.Meter;
import com.google.auto.value.AutoValue;
import java.util.List;
import org.graylog.plugins.pipelineprocessor.ast.AutoValue_Stage;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.processors.PipelineMetricRegistry;

@AutoValue
public abstract class Stage
implements Comparable<Stage> {
    private List<Rule> rules;
    private transient Pipeline pipeline;
    private transient Meter executed;

    public abstract int stage();

    public abstract Match match();

    public abstract List<String> ruleReferences();

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public static Builder builder() {
        return new AutoValue_Stage.Builder();
    }

    public abstract Builder toBuilder();

    @Override
    public int compareTo(Stage other) {
        return Integer.compare(this.stage(), other.stage());
    }

    public void registerMetrics(PipelineMetricRegistry metricRegistry, String pipelineId) {
        this.executed = metricRegistry.registerStageMeter(pipelineId, this.stage(), "executed");
    }

    public void markExecution() {
        if (this.executed != null) {
            this.executed.mark();
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public String toString() {
        return "Stage " + this.stage();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Stage build();

        public abstract Builder stage(int var1);

        public abstract Builder match(Match var1);

        public abstract Builder ruleReferences(List<String> var1);
    }

    public static enum Match {
        ALL,
        EITHER,
        PASS;

    }
}

