/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.mongodb;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.DeleteResult;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.db.RuleService;
import org.graylog.plugins.pipelineprocessor.events.RulesChangedEvent;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.events.ClusterEventBus;

public class MongoDbRuleService
implements RuleService {
    private static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(MongoDbRuleService.class);
    private static final String COLLECTION = "pipeline_processor_rules";
    private final MongoCollection<RuleDao> collection;
    private final ClusterEventBus clusterBus;
    private final MongoUtils<RuleDao> mongoUtils;

    @Inject
    public MongoDbRuleService(MongoCollections mongoCollections, ClusterEventBus clusterBus) {
        this.collection = mongoCollections.collection(COLLECTION, RuleDao.class);
        this.mongoUtils = mongoCollections.utils(this.collection);
        this.clusterBus = clusterBus;
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"title"}), new IndexOptions().unique(true));
    }

    @Override
    public RuleDao save(RuleDao rule) {
        RuleDao savedRule;
        String ruleId = rule.id();
        if (ruleId != null) {
            this.collection.replaceOne(MongoUtils.idEq(ruleId), (Object)rule, new ReplaceOptions().upsert(true));
            savedRule = rule;
        } else {
            String insertedId = MongoUtils.insertedIdAsString(this.collection.insertOne((Object)rule));
            savedRule = rule.toBuilder().id(insertedId).build();
        }
        this.clusterBus.post(RulesChangedEvent.updatedRuleId(savedRule.id()));
        return savedRule;
    }

    @Override
    public RuleDao load(String id) throws NotFoundException {
        return this.mongoUtils.getById(id).orElseThrow(() -> new NotFoundException("No rule with id " + id));
    }

    @Override
    public RuleDao loadByName(String name) throws NotFoundException {
        RuleDao rule = (RuleDao)this.collection.find(Filters.eq((String)"title", (Object)name)).first();
        if (rule == null) {
            throw new NotFoundException("No rule with name " + name);
        }
        return rule;
    }

    @Override
    public Collection<RuleDao> loadAll() {
        try {
            return this.collection.find().sort(Sorts.ascending((String[])new String[]{"title"})).into(new LinkedHashSet());
        }
        catch (MongoException e) {
            log.error("Unable to load processing rules", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public void delete(String id) {
        DeleteResult deleteResult = this.collection.deleteOne(MongoUtils.idEq(id));
        if (deleteResult.getDeletedCount() != 1L) {
            log.error("Unable to delete rule {}", (Object)id);
        }
        this.clusterBus.post(RulesChangedEvent.deletedRuleId(id));
    }

    @Override
    public Collection<RuleDao> loadNamed(Collection<String> ruleNames) {
        try {
            return this.collection.find(Filters.in((String)"title", ruleNames)).into(new LinkedHashSet());
        }
        catch (MongoException e) {
            log.error("Unable to bulk load rules", (Throwable)e);
            return Collections.emptySet();
        }
    }
}

