/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.processors;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.graylog2.shared.utilities.StringUtils;

public class PipelineMetricRegistry {
    private final MetricRegistry registry;
    private final String pipelinesPrefix;
    private final String rulesPrefix;

    public static PipelineMetricRegistry create(MetricRegistry metricRegistry, String pipelinesPrefix, String rulesPrefix) {
        return new PipelineMetricRegistry(metricRegistry, pipelinesPrefix, rulesPrefix);
    }

    private PipelineMetricRegistry(MetricRegistry metricRegistry, String pipelinesPrefix, String rulesPrefix) {
        this.registry = Objects.requireNonNull(metricRegistry, "metricRegistry is null");
        this.pipelinesPrefix = StringUtils.requireNonBlank(pipelinesPrefix, "pipelinesPrefix is blank");
        this.rulesPrefix = StringUtils.requireNonBlank(rulesPrefix, "rulesPrefix is blank");
    }

    public Meter registerPipelineMeter(String pipelineId, String name) {
        return this.registry.meter(MetricRegistry.name((String)this.pipelinesPrefix, (String[])new String[]{StringUtils.requireNonBlank(pipelineId, "pipelineId is blank"), StringUtils.requireNonBlank(name, "name is blank")}));
    }

    public Meter registerStageMeter(String pipelineId, int stage, String name) {
        return this.registry.meter(MetricRegistry.name((String)this.pipelinesPrefix, (String[])new String[]{StringUtils.requireNonBlank(pipelineId, "pipelineId is blank"), "stage", String.valueOf(stage), StringUtils.requireNonBlank(name, "name is blank")}));
    }

    public Meter registerLocalRuleMeter(String pipelineId, int stage, String ruleId, String name) {
        return this.registry.meter(MetricRegistry.name((String)this.rulesPrefix, (String[])new String[]{StringUtils.requireNonBlank(ruleId, "ruleId is blank"), StringUtils.requireNonBlank(pipelineId, "pipelineId is blank"), String.valueOf(stage), StringUtils.requireNonBlank(name, "name is blank")}));
    }

    public Meter registerGlobalRuleMeter(String ruleId, String name) {
        return this.registry.meter(MetricRegistry.name((String)this.rulesPrefix, (String[])new String[]{StringUtils.requireNonBlank(ruleId, "ruleId is blank"), StringUtils.requireNonBlank(name, " name is blank")}));
    }

    public void removePipelineMetrics(String pipelineId) {
        this.registry.removeMatching(MetricFilter.startsWith((String)MetricRegistry.name((String)this.pipelinesPrefix, (String[])new String[]{StringUtils.requireNonBlank(pipelineId, "pipelineId is blank")})));
    }

    public void removeRuleMetrics(String ruleId) {
        this.registry.removeMatching(MetricFilter.startsWith((String)MetricRegistry.name((String)this.rulesPrefix, (String[])new String[]{StringUtils.requireNonBlank(ruleId, "ruleId is blank")})));
    }
}

