/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.processors;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.processors.PipelineMetricRegistry;
import org.graylog.plugins.pipelineprocessor.processors.PipelineResolverConfig;
import org.graylog.plugins.pipelineprocessor.rest.PipelineConnections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineResolver.class);
    private final PipelineRuleParser ruleParser;
    private final PipelineResolverConfig config;
    private final Supplier<Stream<RuleDao>> ruleDaoSupplier;
    private final Supplier<Stream<PipelineDao>> pipelineDaoSupplier;
    private final Supplier<Stream<PipelineConnections>> pipelineConnectionsSupplier;

    @Inject
    public PipelineResolver(@Assisted PipelineRuleParser ruleParser, @Assisted PipelineResolverConfig config) {
        this.ruleParser = ruleParser;
        this.config = config;
        this.ruleDaoSupplier = config.rulesSupplier();
        this.pipelineDaoSupplier = config.pipelinesSupplier();
        this.pipelineConnectionsSupplier = config.pipelineConnectionsSupplier();
    }

    public PipelineResolverConfig config() {
        return this.config;
    }

    public ImmutableMap<String, Pipeline> resolveFunctions(Collection<Pipeline> pipelines, PipelineMetricRegistry pipelineMetricRegistry) {
        Map<String, Rule> ruleNameMap = this.resolveRules();
        ImmutableMap.Builder pipelineIdMap = ImmutableMap.builder();
        for (Pipeline pipeline : pipelines) {
            String id = Objects.requireNonNull(pipeline.id(), "pipeline ID can't be null");
            pipelineIdMap.put((Object)id, (Object)this.resolvePipeline(pipelineMetricRegistry, pipeline, ruleNameMap));
        }
        return pipelineIdMap.build();
    }

    private Map<String, Rule> resolveRules() {
        HashMap ruleNameMap = Maps.newHashMap();
        try (Stream<RuleDao> ruleStream = this.ruleDaoSupplier.get();){
            ruleStream.forEach(ruleDao -> {
                Rule rule;
                try {
                    rule = this.ruleParser.parseRule(ruleDao.id(), ruleDao.source(), false);
                }
                catch (ParseException e) {
                    LOG.warn("Ignoring non parseable rule <{}/{}> with errors <{}>", new Object[]{ruleDao.title(), ruleDao.id(), e.getErrors()});
                    rule = Rule.alwaysFalse("Failed to parse rule: " + ruleDao.id());
                }
                ruleNameMap.put(rule.name(), rule);
            });
        }
        return ruleNameMap;
    }

    public ImmutableMap<String, Pipeline> resolvePipelines(PipelineMetricRegistry pipelineMetricRegistry) {
        Map<String, Rule> ruleNameMap = this.resolveRules();
        ImmutableMap.Builder pipelineIdMap = ImmutableMap.builder();
        try (Stream<PipelineDao> pipelineStream = this.pipelineDaoSupplier.get();){
            pipelineStream.forEach(pipelineDao -> {
                Pipeline pipeline;
                try {
                    pipeline = this.ruleParser.parsePipeline(pipelineDao.id(), pipelineDao.source());
                }
                catch (ParseException e) {
                    LOG.warn("Ignoring non parseable pipeline <{}/{}> with errors <{}>", new Object[]{pipelineDao.title(), pipelineDao.id(), e.getErrors()});
                    pipeline = Pipeline.empty("Failed to parse pipeline: " + pipelineDao.id());
                }
                pipelineIdMap.put((Object)pipelineDao.id(), (Object)this.resolvePipeline(pipelineMetricRegistry, pipeline, ruleNameMap));
            });
        }
        return pipelineIdMap.build();
    }

    public ImmutableSetMultimap<String, Pipeline> resolveStreamConnections(Map<String, Pipeline> currentPipelines) {
        HashMultimap connections = HashMultimap.create();
        try (Stream<PipelineConnections> pipelineConnectionsStream = this.pipelineConnectionsSupplier.get();){
            pipelineConnectionsStream.forEach(streamConnection -> streamConnection.pipelineIds().stream().map(currentPipelines::get).filter(Objects::nonNull).forEach(pipeline -> connections.put((Object)streamConnection.streamId(), pipeline)));
        }
        return ImmutableSetMultimap.copyOf((Multimap)connections);
    }

    @Nonnull
    private Pipeline resolvePipeline(PipelineMetricRegistry pipelineMetricRegistry, Pipeline pipeline, Map<String, Rule> ruleNameMap) {
        LOG.debug("Resolving pipeline <{}>", (Object)pipeline.name());
        pipeline.stages().forEach(stage -> {
            List<Rule> resolvedRules = stage.ruleReferences().stream().map(ref -> {
                Rule rule = (Rule)ruleNameMap.get(ref);
                if (rule == null) {
                    LOG.warn("Cannot resolve rule <{}> referenced by stage #{} within pipeline <{}>", new Object[]{ref, stage.stage(), pipeline.id()});
                    rule = Rule.alwaysFalse("Unresolved rule " + ref);
                }
                rule = rule.copy();
                LOG.debug("Resolved rule <{}> to <{}>", ref, (Object)rule);
                rule.registerMetrics(pipelineMetricRegistry, pipeline.id(), stage.stage());
                return rule;
            }).collect(Collectors.toList());
            stage.setRules(resolvedRules);
            stage.setPipeline(pipeline);
            stage.registerMetrics(pipelineMetricRegistry, pipeline.id());
        });
        pipeline.registerMetrics(pipelineMetricRegistry);
        return pipeline;
    }

    public static interface Factory {
        public PipelineResolver create(PipelineResolverConfig var1, PipelineRuleParser var2);
    }
}

