/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.parser;

import com.swrve.ratelimitedlogger.RateLimitedLog;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilder;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderStep;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.ActionParser;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.ConditionParser;
import org.graylog2.bindings.providers.SecureFreemarkerConfigProvider;

@Singleton
public class RuleBuilderService {
    private static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(RuleBuilderService.class);
    private final String RULE_TEMPLATE = "rule \"%s\"" + System.lineSeparator() + "when" + System.lineSeparator() + "%s" + System.lineSeparator() + "then" + System.lineSeparator() + "%s" + System.lineSeparator() + "end";
    private final ConditionParser conditionParser;
    private final ActionParser actionParser;
    private final Configuration freemarkerConfiguration;

    @Inject
    public RuleBuilderService(ConditionParser conditionParser, ActionParser actionParser, SecureFreemarkerConfigProvider secureFreemarkerConfigProvider) {
        this.conditionParser = conditionParser;
        this.actionParser = actionParser;
        this.freemarkerConfiguration = secureFreemarkerConfigProvider.get();
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        conditionParser.getConditions().forEach((key, value) -> templateLoader.putTemplate(key, value.descriptor().ruleBuilderTitle()));
        actionParser.getActions().forEach((key, value) -> templateLoader.putTemplate(key, value.descriptor().ruleBuilderTitle()));
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
    }

    public String generateRuleSource(String title, RuleBuilder ruleBuilder, boolean generateSimulatorFields) {
        String rule = String.format(Locale.ROOT, this.RULE_TEMPLATE, title, this.conditionParser.generate(ruleBuilder.conditions(), ruleBuilder.operator(), 1), this.actionParser.generate(ruleBuilder.actions(), generateSimulatorFields));
        log.debug(rule);
        return rule;
    }

    public String generateSimulatorRuleSourceEvaluatingConditions(RuleBuilder ruleBuilder) {
        String rule = String.format(Locale.ROOT, this.RULE_TEMPLATE, "condition_evaluation", this.conditionParser.generate(new ArrayList<RuleBuilderStep>(), RuleBuilderStep.Operator.AND, 1), this.conditionParser.generateConditionVariables(ruleBuilder.conditions()));
        log.debug(rule);
        return rule;
    }

    public RuleBuilder generateTitles(RuleBuilder ruleBuilder) {
        return ruleBuilder.toBuilder().conditions(this.generateStepTitles(ruleBuilder.conditions())).actions(this.generateStepTitles(ruleBuilder.actions())).build();
    }

    private List<RuleBuilderStep> generateStepTitles(List<RuleBuilderStep> steps) {
        if (Objects.isNull(steps)) {
            return Collections.emptyList();
        }
        return steps.stream().map(this::generateStepTitle).collect(Collectors.toList());
    }

    private RuleBuilderStep generateStepTitle(RuleBuilderStep step) {
        String title;
        try {
            StringWriter writer = new StringWriter();
            Template template = this.freemarkerConfiguration.getTemplate(step.function());
            template.process(step.parameters(), (Writer)writer);
            writer.close();
            title = writer.toString();
        }
        catch (Exception e) {
            title = step.function();
        }
        return step.toBuilder().title(title).build();
    }
}

