/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.action;

import java.util.Map;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderRegistry;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderStep;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.ValidationResult;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.Validator;

public class ValidNegation
implements Validator {
    private final Map<String, RuleFragment> actions;

    public ValidNegation(RuleBuilderRegistry ruleBuilderRegistry) {
        this.actions = ruleBuilderRegistry.actionsWithInternal();
    }

    @Override
    public ValidationResult validate(RuleBuilderStep step) {
        RuleFragment ruleFragment = this.actions.get(step.function());
        if (step.negate()) {
            if (ruleFragment.isFragment()) {
                return new ValidationResult(true, "Negation of fragments not possible ");
            }
            FunctionDescriptor function = ruleFragment.descriptor();
            if (!function.returnType().equals(Boolean.class)) {
                return new ValidationResult(true, "None boolean function " + step.function() + " cannot be negated.");
            }
        }
        return new ValidationResult(false, "");
    }
}

