/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.migrations;

import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.Set;
import org.graylog2.contentpacks.ContentPackInstallationPersistenceService;
import org.graylog2.contentpacks.ContentPackPersistenceService;
import org.graylog2.contentpacks.ContentPackService;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.contentpacks.model.ContentPackInstallation;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20240531101100_RemoveAbusechContentPack
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20240531101100_RemoveAbusechContentPack.class);
    private static final ModelId CONTENT_PACK_ID = ModelId.of("cbacd801-7824-c554-3fb1-475491b03826");
    private final ContentPackService contentPackService;
    private final ContentPackPersistenceService contentPackPersistenceService;
    private final ContentPackInstallationPersistenceService contentPackInstallationPersistenceService;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20240531101100_RemoveAbusechContentPack(ContentPackService contentPackService, ContentPackPersistenceService contentPackPersistenceService, ContentPackInstallationPersistenceService contentPackInstallationPersistenceService, ClusterConfigService clusterConfigService) {
        this.contentPackService = contentPackService;
        this.contentPackPersistenceService = contentPackPersistenceService;
        this.contentPackInstallationPersistenceService = contentPackInstallationPersistenceService;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2024-05-31T10:11:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed!");
            return;
        }
        Set<ContentPack> existingPacks = this.contentPackPersistenceService.findAllById(CONTENT_PACK_ID);
        if (!existingPacks.isEmpty()) {
            LOG.debug("Removing deprecated Abuse.ch content pack");
            existingPacks.forEach(pack -> {
                this.contentPackInstallationPersistenceService.findByContentPackIdAndRevision(CONTENT_PACK_ID, pack.revision()).forEach(i -> this.contentPackService.uninstallContentPack((ContentPack)pack, (ContentPackInstallation)i));
                this.contentPackPersistenceService.deleteById(pack.id());
            });
        }
        this.clusterConfigService.write(new MigrationCompleted());
    }

    record MigrationCompleted() {
    }
}

