/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.favorites;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mongodb.BasicDBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.result.InsertOneResult;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.bson.conversions.Bson;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.plugins.views.favorites.Favorite;
import org.graylog.plugins.views.favorites.FavoritesForUserDTO;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.startpage.recentActivities.ActivityType;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityEvent;
import org.graylog.plugins.views.startpage.title.StartPageItemTitleRetriever;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.users.events.UserDeletedEvent;

public class FavoritesService {
    public static final String COLLECTION_NAME = "favorites";
    private final StartPageItemTitleRetriever startPageItemTitleRetriever;
    private final GRNRegistry grnRegistry;
    private final MongoCollection<FavoritesForUserDTO> db;
    private final MongoUtils<FavoritesForUserDTO> mongoUtils;

    @Inject
    protected FavoritesService(MongoCollections mongoCollections, EventBus eventBus, StartPageItemTitleRetriever startPageItemTitleRetriever, GRNRegistry grnRegistry) {
        this.db = mongoCollections.collection(COLLECTION_NAME, FavoritesForUserDTO.class);
        eventBus.register((Object)this);
        this.startPageItemTitleRetriever = startPageItemTitleRetriever;
        this.grnRegistry = grnRegistry;
        this.mongoUtils = mongoCollections.utils(this.db);
        this.db.createIndex(Indexes.ascending((String[])new String[]{"user_id"}));
        this.db.createIndex(Indexes.ascending((String[])new String[]{"items"}));
    }

    public PaginatedResponse<Favorite> findFavoritesFor(SearchUser searchUser, Optional<String> type, int page, int perPage) {
        List items = this.findForUser(searchUser).orElse(new FavoritesForUserDTO(searchUser.getUser().getId(), List.of())).items().stream().filter(i -> type.isEmpty() || i.type().equals(type.get())).map(i -> this.startPageItemTitleRetriever.retrieveTitle((GRN)i, searchUser).map(title -> new Favorite((GRN)i, (String)title))).flatMap(Optional::stream).toList();
        return PaginatedResponse.create(COLLECTION_NAME, new PaginatedList(PaginatedDbService.getPage(items, page, perPage), items.size(), page, perPage));
    }

    public void save(FavoritesForUserDTO favorite) {
        if (favorite.id() == null) {
            this.create(favorite);
        } else {
            this.db.replaceOne(MongoUtils.idEq(favorite.id()), (Object)favorite);
        }
    }

    public void addFavoriteItemFor(String in, SearchUser searchUser) {
        GRN grn = this.grnRegistry.parse(in);
        Optional<FavoritesForUserDTO> favorites = this.findForUser(searchUser);
        if (favorites.isPresent()) {
            FavoritesForUserDTO fi = favorites.get();
            if (fi.items() != null && fi.items().stream().noneMatch(g -> g.toString().equalsIgnoreCase(in))) {
                fi.items().add(0, grn);
                this.save(fi);
            }
        } else {
            FavoritesForUserDTO items = new FavoritesForUserDTO(searchUser.getUser().getId(), List.of(grn));
            this.create(items);
        }
    }

    public void removeFavoriteItemFor(String in, SearchUser searchUser) {
        GRN grn = this.grnRegistry.parse(in);
        Optional<FavoritesForUserDTO> favorites = this.findForUser(searchUser);
        if (favorites.isPresent() && favorites.get().items() != null) {
            FavoritesForUserDTO fi = favorites.get();
            List<GRN> items = fi.items().stream().filter(i -> !i.equals(grn)).toList();
            fi.items().clear();
            fi.items().addAll(items);
            this.save(fi);
        }
    }

    Optional<FavoritesForUserDTO> findForUser(SearchUser searchUser) {
        return this.findForUser(searchUser.getUser().getId());
    }

    Optional<FavoritesForUserDTO> findForUser(String userId) {
        return MongoUtils.stream(this.db.find(Filters.eq((String)"user_id", (Object)userId))).findAny();
    }

    public Stream<FavoritesForUserDTO> streamAll() {
        return MongoUtils.stream(this.db.find());
    }

    public Optional<FavoritesForUserDTO> create(FavoritesForUserDTO favorite) {
        try {
            InsertOneResult result = this.db.insertOne((Object)favorite);
            return this.mongoUtils.getById(MongoUtils.insertedId(result));
        }
        catch (DuplicateKeyException e) {
            throw new IllegalStateException("Unable to create a Favorites collection, collection with this id already exists : " + favorite.id());
        }
    }

    @Subscribe
    public void removeFavoriteOnEntityDeletion(RecentActivityEvent event) {
        if (event.activityType().equals((Object)ActivityType.DELETE)) {
            String grn = event.grn().toString();
            BasicDBObject query = new BasicDBObject("items", (Object)grn);
            BasicDBObject modifications = new BasicDBObject("$pull", (Object)new BasicDBObject("items", (Object)grn));
            this.db.updateMany((Bson)query, (Bson)modifications);
        }
    }

    @Subscribe
    public void removeFavoriteEntityOnUserDeletion(UserDeletedEvent event) {
        this.db.deleteOne(Filters.eq((String)"user_id", (Object)event.userId()));
    }
}

