/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.AutoValue_V20191203120602_MigrateSavedSearchesToViews_MigrationCompleted;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.savedsearch.SavedSearch;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.savedsearch.SavedSearchService;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.search.Query;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.search.Search;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.search.SearchService;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.search.SearchType;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.AggregationWidget;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.Position;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.RandomObjectIdProvider;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.RandomUUIDProvider;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.Titles;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.View;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.ViewService;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.ViewState;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.ViewWidget;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.ViewWidgetPosition;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20191203120602_MigrateSavedSearchesToViews
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20191203120602_MigrateSavedSearchesToViews.class);
    private final ClusterConfigService clusterConfigService;
    private final SavedSearchService savedSearchService;
    private final SearchService searchService;
    private final ViewService viewService;
    private final RandomObjectIdProvider randomObjectIdProvider;
    private final RandomUUIDProvider randomUUIDProvider;

    @Inject
    public V20191203120602_MigrateSavedSearchesToViews(ClusterConfigService clusterConfigService, SavedSearchService savedSearchService, SearchService searchService, ViewService viewService, RandomObjectIdProvider randomObjectIdProvider, RandomUUIDProvider randomUUIDProvider) {
        this.clusterConfigService = clusterConfigService;
        this.savedSearchService = savedSearchService;
        this.searchService = searchService;
        this.viewService = viewService;
        this.randomObjectIdProvider = randomObjectIdProvider;
        this.randomUUIDProvider = randomUUIDProvider;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2019-12-03T12:06:02Z");
    }

    @Override
    public void upgrade() {
        if (this.hasBeenRunSuccessfully()) {
            LOG.debug("Migration already completed.");
            return;
        }
        HashMap<String, String> savedSearchToViewsMap = new HashMap<String, String>();
        Map<View, Search> newViews = this.savedSearchService.streamAll().map(savedSearch -> {
            Map.Entry<View, Search> newView = this.migrateSavedSearch((SavedSearch)savedSearch);
            savedSearchToViewsMap.put(savedSearch.id(), newView.getKey().id());
            return newView;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        newViews.forEach((view, search) -> {
            this.viewService.save((View)view);
            this.searchService.save((Search)search);
        });
        MigrationCompleted migrationCompleted = MigrationCompleted.create(savedSearchToViewsMap);
        this.writeMigrationCompleted(migrationCompleted);
    }

    private Map.Entry<View, Search> migrateSavedSearch(SavedSearch savedSearch) {
        String histogramId = this.randomUUIDProvider.get();
        String messageListId = this.randomUUIDProvider.get();
        ImmutableSet widgets = ImmutableSet.of((Object)AggregationWidget.create(histogramId), (Object)savedSearch.query().toMessagesWidget(messageListId));
        HashMap<String, Set<String>> widgetMapping = new HashMap<String, Set<String>>(widgets.size());
        Set<SearchType> searchTypes = widgets.stream().flatMap(widget -> {
            Set<SearchType> widgetSearchTypes = widget.toSearchTypes(this.randomUUIDProvider);
            widgetMapping.put(widget.id(), widgetSearchTypes.stream().map(SearchType::id).collect(Collectors.toSet()));
            return widgetSearchTypes.stream();
        }).collect(Collectors.toSet());
        Query.Builder queryBuilder = Query.builder().id(this.randomUUIDProvider.get()).timerange(savedSearch.query().toTimeRange()).query(savedSearch.query().query()).searchTypes(searchTypes);
        Query query = savedSearch.query().streamId().map(queryBuilder::streamId).orElse(queryBuilder).build();
        Search newSearch = Search.create(this.randomObjectIdProvider.get(), Collections.singleton(query), savedSearch.creatorUserId(), savedSearch.createdAt());
        Titles titles = Titles.ofWidgetTitles((Map<String, String>)ImmutableMap.of((Object)histogramId, (Object)"Message Count", (Object)messageListId, (Object)"All Messages"));
        ImmutableMap widgetPositions = ImmutableMap.of((Object)histogramId, (Object)ViewWidgetPosition.builder().col(Position.fromInt(1)).row(Position.fromInt(1)).height(Position.fromInt(2)).width(Position.infinity()).build(), (Object)messageListId, (Object)ViewWidgetPosition.builder().col(Position.fromInt(1)).row(Position.fromInt(3)).height(Position.fromInt(6)).width(Position.infinity()).build());
        ViewState viewState = ViewState.create(titles, (Set<ViewWidget>)widgets, widgetMapping, (Map<String, ViewWidgetPosition>)widgetPositions);
        View newView = View.create(this.randomObjectIdProvider.get(), "Saved Search: " + savedSearch.title(), "This Search was migrated automatically from the \"" + savedSearch.title() + "\" saved search.", "", newSearch.id(), Collections.singletonMap(query.id(), viewState), Optional.of(savedSearch.creatorUserId()), savedSearch.createdAt());
        return new AbstractMap.SimpleEntry<View, Search>(newView, newSearch);
    }

    private boolean hasBeenRunSuccessfully() {
        return this.clusterConfigService.get(MigrationCompleted.class) != null;
    }

    private void writeMigrationCompleted(MigrationCompleted migrationCompleted) {
        this.clusterConfigService.write(migrationCompleted);
    }

    @AutoValue
    public static abstract class MigrationCompleted {
        static final String FIELD_SAVED_SEARCH_IDS = "saved_search_ids";

        @JsonProperty(value="saved_search_ids")
        public abstract Map<String, String> savedSearchIds();

        @JsonCreator
        static MigrationCompleted create(@JsonProperty(value="saved_search_ids") Map<String, String> savedSearchIds) {
            return new AutoValue_V20191203120602_MigrateSavedSearchesToViews_MigrationCompleted(savedSearchIds);
        }
    }
}

