/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.List;
import org.graylog.plugins.views.search.Search;
import org.graylog2.database.MongoCollections;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20240605120000_RemoveUnitFieldFromSearchDocuments
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20240605120000_RemoveUnitFieldFromSearchDocuments.class);
    private final MongoCollection<Search> searchesCollection;

    @Inject
    public V20240605120000_RemoveUnitFieldFromSearchDocuments(MongoCollections mongoCollections) {
        this.searchesCollection = mongoCollections.collection("searches", Search.class);
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2024-06-05T12:00:00Z");
    }

    @Override
    public void upgrade() {
        UpdateResult updateResult = this.searchesCollection.updateMany(Filters.exists((String)"queries.search_types.series.unit"), Updates.unset((String)"queries.$[query].search_types.$[type].series.$[elem].unit"), new UpdateOptions().arrayFilters(List.of(Filters.exists((String)"query.search_types"), Filters.exists((String)"type.series"), Filters.exists((String)"elem.unit"))));
        if (updateResult.getModifiedCount() > 0L) {
            LOG.info("Removed outdated unit field from " + updateResult.getModifiedCount() + " searches");
        }
    }
}

