/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.graylog.plugins.views.migrations.V20190127111728_MigrateWidgetFormatSettings;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20240704100700_DashboardAddLastUpdated
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20190127111728_MigrateWidgetFormatSettings.class);
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<ViewDTO> viewsCollection;
    private final MongoCollection<Search> searchesCollection;

    @Inject
    public V20240704100700_DashboardAddLastUpdated(ClusterConfigService clusterConfigService, MongoCollections mongoCollections) {
        this.clusterConfigService = clusterConfigService;
        this.viewsCollection = mongoCollections.collection("views", ViewDTO.class);
        this.searchesCollection = mongoCollections.collection("searches", Search.class);
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2024-07-04T10:07:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        ArrayList views = (ArrayList)this.viewsCollection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"last_updated_at", null), Filters.eq((String)"type", (Object)((Object)ViewDTO.Type.DASHBOARD))})).into(new ArrayList());
        List<String> searchIds = views.stream().map(ViewDTO::searchId).toList();
        Map searches = ((ArrayList)this.searchesCollection.find(Filters.in((String)"id", searchIds)).into(new ArrayList())).stream().collect(Collectors.toMap(Search::id, Function.identity()));
        views.forEach(v -> {
            Search search = (Search)searches.get(v.searchId());
            ViewDTO n = v.toBuilder().lastUpdatedAt(search != null ? search.createdAt() : v.createdAt()).build();
            this.viewsCollection.replaceOne(MongoUtils.idEq(n.id()), (Object)n);
        });
        this.clusterConfigService.write(new MigrationCompleted(DateTime.now((DateTimeZone)DateTimeZone.UTC)));
    }

    record MigrationCompleted(DateTime completedAt) {
    }
}

