/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog2.indexer.MongoIndexSet;
import org.graylog2.indexer.ranges.IndexRange;

public record ExplainResults(String search_id, SearchResult search, Set<SearchError> searchErrors) {

    public record SearchResult(Map<String, QueryExplainResult> queries) {
    }

    public record IndexRangeResult(String indexName, long begin, long end, boolean isWarmTiered, Collection<String> streamNames) {
        public IndexRangeResult(String indexName, long begin, long end, Collection<String> streamNames) {
            this(indexName, begin, end, MongoIndexSet.indexHasWarmInfix(indexName), streamNames);
        }

        public static IndexRangeResult fromIndexRange(IndexRange indexRange, Collection<String> streamNames) {
            return new IndexRangeResult(indexRange.indexName(), indexRange.begin().getMillis(), indexRange.end().getMillis(), streamNames);
        }
    }

    public record ExplainResult(String queryString, Set<IndexRangeResult> searchedIndexRanges) {
    }

    public record QueryExplainResult(Map<String, ExplainResult> searchTypes) {
    }
}

